export module game:boardgame.player;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :boardgame.base;

namespace game
{
	namespace boardgame
	{
		namespace internal
		{
			export wind::array_t<ALLEGRO::POINT<float>> empty_path{};
		}

		export class player_t
		{
		public:
			player_t();
			~player_t();
			auto on_update() -> int32_t;
			auto on_render() -> void;
			auto set_path(const wind::array_t<ALLEGRO::POINT<float>>& path) -> void;
			auto get_bitmap() const -> const ALLEGRO::BITMAP&;
			auto set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void;
			auto get_position() const->const ALLEGRO::POINT<float>&;
			auto set_position(const ALLEGRO::POINT<float>& position) -> void;
			auto get_frame() -> int32_t;
			auto set_frame(int32_t frame) -> void;
			auto get_facing() -> float;
			auto set_facing(float radians) -> void;
			auto get_current_marker() -> int32_t;
			auto set_current_marker(int32_t marker) -> void;
			auto get_next_marker() -> int32_t;
			auto set_next_marker(int32_t marker) -> void;
			auto get_moves() -> int32_t;
			auto set_moves(int32_t roll) -> void;
			auto get_dice() -> int32_t;
			auto set_dice(int32_t roll) -> void;
			auto get_state() const->GAME::BOARDGAME::PLAYER::STATE;
			auto set_state(GAME::BOARDGAME::PLAYER::STATE state) -> void;

		private:
			ALLEGRO::BITMAP m_bitmap{};
			ALLEGRO::POINT<float> m_position{ 0, 0 };
			wind::array_t<ALLEGRO::POINT<float>>& m_path{ internal::empty_path };
			int32_t m_current_marker{ 0 };
			int32_t m_next_marker{ 0 };
			int32_t m_frame{ 0 };
			float m_facing{ 1.5f * ALLEGRO::PI };
			int32_t m_moves{ 0 };
			int32_t m_dice{ 0 };
			GAME::BOARDGAME::PLAYER::STATE m_state{ GAME::BOARDGAME::PLAYER::STATE::INVALID };
		};
	}
}