export module game:boardgame.mob;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
import :boardgame.base;

namespace game
{
	namespace boardgame
	{
		namespace internal
		{
			ALLEGRO::POINT<float> empty_point{ 0,0 };
		}

		export class mob_t
		{
		public:
			mob_t();
			~mob_t();
			auto on_update() -> int32_t;
			auto on_render() -> void;
			auto follow(const ALLEGRO::POINT<float>& point);
			auto get_bitmap() const -> const ALLEGRO::BITMAP&;
			auto set_bitmap(const ALLEGRO::BITMAP& bitmap) -> void;
			auto get_marker() -> int32_t;
			auto set_marker(int32_t marker) -> void;
			auto get_position() const->const ALLEGRO::POINT<float>&;
			auto set_position(const ALLEGRO::POINT<float>& position) -> void;
			auto get_type() const->GAME::BOARDGAME::MOB::TYPE;
			auto set_type(GAME::BOARDGAME::MOB::TYPE type) -> void;
			auto get_state() const->GAME::BOARDGAME::MOB::STATE;
			auto set_state(GAME::BOARDGAME::MOB::STATE state) -> void;

		private:
			ALLEGRO::BITMAP m_bitmap{};
			ALLEGRO::POINT<float> m_position{};
			int32_t m_marker{ 0 };
			ALLEGRO::POINT<float>& m_follow{ internal::empty_point };
			GAME::BOARDGAME::MOB::TYPE m_type{ GAME::BOARDGAME::MOB::TYPE::INVALID };
			GAME::BOARDGAME::MOB::STATE m_state{ GAME::BOARDGAME::MOB::STATE::INVALID };
		};
	}
}