export module game:boardgame.base;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import :base;

namespace GAME
{
	namespace BOARDGAME
	{
		const char* PATH_FILENAME = "boardgame_path.json";
		const char* PLACEMENT_FILENAME = "boardgame_item_placement.json";

		export enum class STATE
		{
			INVALID = -1,
			INITIALIZING,
			STARTING,
			WAITING,
			INPUT,
			ROLLING,
			WALKING,
			ATTACKING,
			RECOVERY,
			STOPPING,
			CLOSING,
			GAMEOVER
		};

		namespace MOB
		{
			export constexpr int32_t ATTACK_PERCENT{ 10 };
			export constexpr int32_t ATTACK_DELAY{ 40 };

			export enum class STATE
			{
				INVALID = -1,
				IDLE,
				ATTACK
			};

			export enum class TYPE
			{
				INVALID = -1,
				DRAGON,
				OGRE,
				DEMON,
				COUNT
			};
		}

		namespace TREASURE
		{
			export enum class STATE
			{
				INVALID = -1,
				IDLE,
				TAKEN
			};

			export enum class TYPE
			{
				INVALID = -1,
				PRESENT,
				GIFT,
				SANTA,
				TREE,
				CHEST,
				DEER,
				COUNT
			};
		}

		namespace TILE
		{
			export constexpr ALLEGRO::POINT<int32_t> SHIFT{ 5, 5 };
			export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 1 << SHIFT.x, 1 << SHIFT.y };
		}

		namespace PLAYER
		{
			export constexpr int32_t RECOVERY_DELAY{ 40 };
			export constexpr int32_t HURTING_DELAY{ 40 };
			export const ALLEGRO::POINT<float> DELTA{ -(1 << (GAME::BOARDGAME::TILE::SHIFT.x - 1)), -((float)GAME::BOARDGAME::TILE::SIZE.height - 6.0f) };

			export enum class STATE
			{
				INVALID = -1,
				IDLE,
				MARKING,
				WALKING,
				STOPPED,
				RECOVERY,
				HURTING,
				DEAD,
				WON
			};
		}

		namespace DICE
		{
			export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 32, 32 };
			export constexpr size_t COUNT{ 6 };
			namespace FRAME
			{
				export constexpr ALLEGRO::POINT<int32_t> POSITION{ 434, 168 };
				export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 63, 63 };
			}
		}

		export enum class ITEM_TYPE
		{
			MOB,
			TREASURE,
			BACKGROUND,
			COUNT
		};

		namespace PALETTE
		{
			export enum
			{
				DARK = 0x85546,
				MEDIUM_DARK = 0xf0c8b0,
				MEDIUM_LIGHT = 0xffe3d3,
				LIGHT = 0xffebdf
			};
		}
	}
}