export module game:boardgame;

import <cstdint>;
import <memory>;
import <array>;
import allegro;
import wind;
import wind.datafile_addon;
import :base;
import :game_shared_data;
import :process;
export import :boardgame.base;
export import :boardgame.mob;
export import :boardgame.player;
export import :boardgame.treasure;

namespace game
{
	export class boardgame_t : public process_t
	{
	public:
		boardgame_t();
		~boardgame_t();

		auto on_initialize() -> int32_t override;
		auto on_shutdown() -> int32_t override;
		auto on_start() -> int32_t override;
		auto on_stop() -> int32_t override;
		auto on_update() -> GAME::STATE override;
		auto on_render() -> void override;
		auto get_viewport() -> ALLEGRO::SIZE<int32_t> override;
		auto get_state() const->GAME::BOARDGAME::STATE;
		auto set_state(GAME::BOARDGAME::STATE state) -> void;

	private:
		ALLEGRO::BITMAP m_background{};
		wind::array_t<ALLEGRO::POINT<float>> m_path{};
		std::array<boardgame::mob_t, (size_t)GAME::BOARDGAME::MOB::TYPE::COUNT> m_mobs{};
		std::array<boardgame::treasure_t, (size_t)GAME::BOARDGAME::TREASURE::TYPE::COUNT> m_treasures{};
		boardgame::player_t m_player{};
		GAME::BOARDGAME::STATE m_state{ GAME::BOARDGAME::STATE::INVALID };
		wind::string_t m_caption{};
	};
}