export module game:base;

import <string>;
import <memory>;
import std;
import allegro;
import wind;

namespace GAME
{
	export constexpr uint32_t VERSION{ al::generate_id(0, 0, 0, 1) };
	export const char* TITLE{ "Krampus Hack 2024" };
	export const char* ARCHIVE_FILENAME{ "krampus.7z" };
	export const char* ASSET_DIRECTORY{ "assets" };
	export const char* MANIFESTS_DIRECTORY{ "manifests" };

	namespace BUFFER
	{
		export constexpr ALLEGRO::SIZE<int32_t> SIZE{ 512, 420 };
	}

	export enum class DIRECTION : int32_t
	{
		INVALID = -1,
		EAST,
		NORTH,
		WEST,
		SOUTH,
		COUNT
	};

	export enum class PROCESS : int32_t
	{
		INVALID = -1,
		APPLICATION,
		TITLESCREEN,
		OPTIONS_MENU,
		BOARDGAME,
		DUNGEON,
		GAMEOVER,
		COUNT
	};

	export enum class STATE : int32_t
	{
		INVALID = -1,
		INITIALIZATION,
		TITLE_SCREEN,
		OPTIONS_MENU,
		BOARDGAME,
		DUNGEON,
		GAMEOVER,
		SHUTDOWN
	};
}