export module application;

import <map>;
import <string>;
import <memory>;
import std;
import allegro;
import wind;
import wind.datafile_addon;
import game;

namespace application
{
	export class application_t : public wind::dialog_t
	{
	public:
		/// <summary>Allocates and initializes an application_t object</summary>
		/// <param name=''> - N/A</param>
		/// <returns> - N/A</returns>
		application_t();
		~application_t();

		auto get_version() const->int32_t;
		auto get_title() const -> const wind::string_t&;

		auto on_initialize(const wind::array_t<wind::string_t>& args) -> int32_t override;
		auto on_shutdown() -> int32_t override;
		auto on_start() -> int32_t override;
		auto on_stop() -> int32_t override;
		auto on_update() -> int32_t override;
		auto on_render() -> int32_t override;

	private:
		auto switch_state(GAME::STATE state) -> void;
		auto load_game_data() -> int32_t;

		std::map<GAME::PROCESS, std::shared_ptr<game::process_t>> m_processes{};
		std::shared_ptr<game::process_t> m_process{};
		GAME::STATE m_state{ GAME::STATE::INVALID };
	};
}