unit Orcs;
(*<Orc stuff. *)
(* Copyright (c) 2024 Guillermo Martínez J.

  This software is provided 'as-is', without any express or implied
  warranty. In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
    claim that you wrote the original software. If you use this software
    in a product, an acknowledgment in the product documentation would be
    appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
    distribution.
 *)
interface

  uses
    Classes,
    CastleTransform, CastleUIControls,
    CharacterBehavior, EnemyBehavior;

  const
  (* Max steps by orc. *)
    MaxSteps = 5;
  (* Time hurt state lasts. *)
    TurnsHurt = 1;

  var
  (* Orc states. *)
    WatchState,
    WaitState, WanderState, AttackState, HurtState, DieState: TCharacterSate;

(* Initialize the Orcs of given group. *)
  procedure Initialize (aGroup: TCastleTransform; aDestroyAt: TComponent);

implementation

  uses
    sysutils,
    CharacterDefinition;

  procedure Initialize (aGroup: TCastleTransform; aDestroyAt: TComponent);
  const
    OrcStats: TCharacterValues = (
      Health:   10;
      Strength: 25;
      Defense:  10;
      Armour:    0
    );
  var
    lItem: TCastleTransform;
    lBehavior: TEnemyBehavior;
  begin
    for lItem in aGroup do
    begin
    { Only scenes named 'Orcsomething'. }
      if LeftStr (lItem.Name, 3) <> 'Orc' then Continue;
    { Get behavior. }
      lBehavior := TEnemyBehavior (lItem.FindBehavior (TEnemyBehavior));
      if not Assigned (lBehavior) then
      begin
        lBehavior := TEnemyBehavior.Create (aDestroyAt);
        lItem.AddBehavior (lBehavior)
      end;
    { Init behavior. }
      lBehavior.Stats := OrcStats;
      lBehavior.HurtState := HurtState;
      lBehavior.DieState  := DieState;
      lBehavior.StateMachine.Global := WatchState;
      lBehavior.StateMachine.Current := WaitState
    end;
  end;

initialization
  WatchState := TEnemyWatchState.Create;
  WaitState := TEnemyWaitState.Create;
  WanderState := TWalkState.Create;
  AttackState := TEnemyAttack.Create;
  HurtState := TInterludeState.Create;
  DieState := TDieState.Create;

  TEnemyWatchState (WatchState).AttackState := AttackState;

  TEnemyWaitState (WaitState).WanderState := WanderState;

  TWalkState (WanderState).MaxSteps := MaxSteps;
  TWalkState (WanderState).StopState := WaitState;

  TEnemyAttack (AttackState).StopState := WanderState;
  TEnemyAttack (AttackState).Animation := 'attack-melee-left';

  TInterludeState (HurtState).Animation := 'fall';
  TInterludeState (HurtState).AnimationLoop := False;
  TInterludeState (HurtState).Turns := TurnsHurt;
  TInterludeState (HurtState).ContinueState := WaitState

finalization
  WaitState.Free;
  WanderState.Free;
  AttackState.free;
  HurtState.Free;
  DieState.Free
end.
