unit GameViewMenu;
(*<Implements the initial menu. *)
(* Copyright (c) 2024 Guillermo Martínez J.

  This software is provided 'as-is', without any express or implied
  warranty. In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
    claim that you wrote the original software. If you use this software
    in a product, an acknowledgment in the product documentation would be
    appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
    distribution.
 *)
interface

  uses
    Classes,
    CastleComponentSerialize, CastleKeysMouse, CastleUIControls, CastleControls;

const
(* Mnemonics for button tags. *)
  btnPlay = 1;
  btnHowToPlay = 2;
  btnCredits = 3;
  btnQuit = 4;

type
  { Simple "menu" user interface, that allows to run the game or quit. }
  TViewMenu = class(TCastleView)
  published
    { Components designed using CGE editor.
      These fields will be automatically initialized at Start. }
    ButtonPlay, ButtonHowToPlay, ButtonCredits, ButtonQuit: TCastleButton;
  private
    procedure ButtonClick (aSender: TObject);
  public
    constructor Create (aOwner: TComponent); override;
    procedure Start; override;
  (* Called when user pressed something.
     @param(aEvent )
   *)
    function Press (const aEvent: TInputPressRelease): Boolean; override;
  end;

var
  ViewMenu: TViewMenu;

implementation

  uses
    CastleApplicationProperties, CastleWindow,
    GameViewCredits, GameViewHowToPlay, GameViewSnowtown;

{ TViewMenu ----------------------------------------------------------------- }


  procedure TViewMenu.ButtonClick (aSender: TObject);
  var
    lButton: TCastleButton absolute aSender;
  begin
    case lButton.Tag of
    btnPlay:
      Self.Container.View := ViewSnowtown;
    btnHowToPlay:
      Self.Container.View := ViewHowToPlay;
    btnCredits:
      Self.Container.View := ViewCredits;
    else { otherwise }
      Application.Terminate;
    end
  end;



  constructor TViewMenu.Create (aOwner: TComponent);
  begin
    inherited Create (aOwner);
    Self.DesignUrl := 'castle-data:/gameviewmenu.castle-user-interface'
  end;



  procedure TViewMenu.Start;
  begin
    inherited Start;
    Self.ButtonPlay.OnClick := {$ifdef FPC}@{$endif} Self.ButtonClick;
    Self.ButtonHowToPlay.OnClick := {$ifdef FPC}@{$endif} Self.ButtonClick;
    Self.ButtonCredits.OnClick := {$ifdef FPC}@{$endif} Self.ButtonClick;
  // Hide "Quit" button on mobile/console platforms, where users don't expect such button
    Self.ButtonQuit.Exists := ApplicationProperties.ShowUserInterfaceToQuit;
    if Self.ButtonQuit.Exists then
      Self.ButtonQuit.OnClick := {$ifdef FPC}@{$endif} Self.ButtonClick
  end;



  function TViewMenu.Press (const aEvent: TInputPressRelease): Boolean;
  begin
  { Allow the ancestor to handle keys. }
    if inherited Press (aEvent) then Exit;
    if aEvent.IsKey (keyEscape) then Application.Terminate;
    Result := True
  end;

end.
