unit GameViewDied;
(*<Shows the "You're dead" message. *)
(* Copyright (c) 2024 Guillermo Martínez J.

  This software is provided 'as-is', without any express or implied
  warranty. In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
    claim that you wrote the original software. If you use this software
    in a product, an acknowledgment in the product documentation would be
    appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
    distribution.
 *)
interface

  uses
    Classes,
    CastleVectors, CastleKeysMouse, CastleUIControls, CastleControls;

  type
  (* The view. *)
    TViewDied = class (TCastleView)
    published
    (* Components added by CGE's editor. *)
      ButtonBack: TCastleButton;

      procedure ButtonClick (aSender: TObject);
    public
    (* Constructor. *)
      constructor Create (aOwner: TComponent); override;
    (* View initialization.. *)
      procedure Start; override;
    (* Called when user pressed something.
       @param(aEvent )
     *)
      function Press (const aEvent: TInputPressRelease): Boolean; override;
    end;

  var
  (* Global reference to the view. *)
    ViewDied: TViewDied;

implementation

  uses
    GameViewMenu;

(*
 * TViewDied
 *************************************************************************)

  procedure TViewDied.ButtonClick (aSender: TObject);
  begin
    Self.Container.View := ViewMenu
  end;



  constructor TViewDied.Create (aOwner: TComponent);
  begin
    inherited Create (aOwner);
  { Assign the view description file URL. }
    Self.DesignUrl := 'castle-data:/gameviewdied.castle-user-interface'
  end;



  procedure TViewDied.Start;
  begin
    inherited Start;
    Self.ButtonBack.OnClick := {$ifdef FPC}@{$endif} Self.ButtonClick;
  end;



  function TViewDied.Press (const aEvent: TInputPressRelease): Boolean;
  begin
  { Allow the ancestor to handle keys. }
    if inherited Press (aEvent) then Exit;
    if aEvent.IsKey (keyEscape) then Self.Container.View := ViewMenu;
    Result := True
  end;

end.
