unit CharacterDefinition;
(*<Stuff to define a character. *)
(* Copyright (c) 2024 Guillermo Martínez J.

  This software is provided 'as-is', without any express or implied
  warranty. In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
    claim that you wrote the original software. If you use this software
    in a product, an acknowledgment in the product documentation would be
    appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
    distribution.
 *)
interface

  type
  (* Character properties.  Most values are |1..100|. *)
    TCharacterValues = record
    (* Current health.  Less than zero is dead. *)
      Health,
    (* How much hurt it can. *)
      Strength,
    (* Used to dribble, avoid attacks...  Percentage. *)
      Defense,
    (* Reduces attack damage.  Percentage. *)
      Armour: Integer;
    end;

(* Calculate attack result.
   @param(aAttacker Values for the attacker.)
   @param(aDefender Values for the defender.)
   @result(How much damage the defender receibes.  If 0 then attacker missed.)
 *)
  function DoAttack (const aAttacker, aDefender: TCharacterValues): Integer;

implementation

  uses
CastleLog;

  function DoAttack (const aAttacker, aDefender: TCharacterValues): Integer;
  begin
  { Check if attacker miss the attack. }
//WritelnLog ('DoAttack', 'Defense: %d', [aDefender.Defense]);
    if Random (100) < aDefender.Defense then Exit (0);
  { Calculate damage. }
    Result := aAttacker.Strength;
//WritelnLog ('DoAttack', 'Strength: %d', [aAttacker.Strength]);
//WritelnLog ('DoAttack', 'Armour: %d', [aDefender.Armour]);
    if aDefender.Armour > 0 then Result := Result - Random (aDefender.Armour)
//; WritelnLog ('DoAttack', 'Damage: %d', [Result]);
  end;

end.
