#ifndef TEXT_H
#define TEXT_H

#ifdef CPC
#include <cpctelera.h>
#elif ALLEGRO4
#include <allegro.h>
#include <stdio.h>
#else
#include <allegro5/allegro.h>
#include <allegro5/allegro_font.h>
#include <stdio.h>
#endif

#include "GameTypes.h"

// Draws a string at a specified position on screen using the game font.
#ifdef CPC
void drawString(u8 x, u8 y, const u8* string);
#else
void drawString(u16 x, u16 y, u8 scaleFactor, const u8* string, ALLEGRO_COLOR textColour);
#endif

#ifndef CPC
// Initialise fonts used by Allegro.
i8 initFonts(const u8* fontPath);

// Destroy fonts used by Allegro.
void destroyFonts();
#endif
#endif

// Converts a 16 bit number to an equivalent string of characters for printing on screen.
void convertNumberToString(u16 input, u8* output);

// Draws the specified score at the specified position with appropriate zero padding.
#ifdef CPC
void drawScore(u16 score, u8 scoreStartPosition, u8 yPosition);
#else
void drawScore(i32 score, u16 x, u16 y, u8 scaleFactor, ALLEGRO_COLOR textColour);
#endif
