#include "Text.h"

// The offset used for converting a number to ascii for drawing on screen.
#define ASCII_TO_NUMBER_OFFSET_ 48

#ifdef CPC

// The width of a character from the font when drawing on screen.
#define CHARACTER_WIDTH_ 2

// The height of a character from the font when drawing on screen.
#define CHARACTER_HEIGHT_ 8

// Basic CPC font.
const u8 G_basic_font_[624] =
{
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x00, 0x00,
    0xC0, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0xC0, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x40, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0xC0, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x00,
    0x00, 0x00,
    0x40, 0x00,
    0x80, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x80,
    0x40, 0x00,
    0x00, 0x00,
    0xC0, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x00,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x00, 0x00,
    0x40, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x40, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0xC0, 0x80,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0xC0, 0x80,
    0x00, 0x00,
    0x40, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0x80, 0x80,
    0xC0, 0x00,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x00,
    0xC0, 0x00,
    0xC0, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0x40, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x40, 0x00,
    0x00, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0x00, 0x00,
    0x40, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x00,
    0x40, 0x80,
    0x00, 0x00,
    0xC0, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x00,
    0xC0, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0x40, 0x80,
    0x80, 0x00,
    0x80, 0x00,
    0x40, 0x80,
    0x00, 0x80,
    0x00, 0x80,
    0xC0, 0x00,
    0x00, 0x00,
    0xC0, 0x80,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x40, 0x00,
    0x40, 0x00,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0xC0, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x40, 0x00,
    0xC0, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0x00, 0x00,
    0x80, 0x80,
    0x80, 0x80,
    0x80, 0x80,
    0xC0, 0x80,
    0x40, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x00, 0x00,
    0xC0, 0x80,
    0x00, 0x80,
    0x40, 0x00,
    0x40, 0x00,
    0x80, 0x00,
    0x80, 0x00,
    0xC0, 0x80,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x40, 0x00,
    0x40, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0xC0, 0x80,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00
};

void drawString(u8 x, u8 y, const u8* string)
{
    u8* memory = cpct_getScreenPtr(CPCT_VMEM_START, x, y);
    u8* position = string;

    while (*position != 0)
    {
        u8 character = *position;

        if (character == 32)
        {
            // Space
            character = 36;
        }
        else if (character == 46)
        {
            // dot .
            character = 37;
        }
        else if (character < 58)
        {
            // Numbers.
            character -= 48;
        }
        else
        {
            // Lower case letters.
            character -= 87;
        }

        // Multiply character by 16.
        cpct_drawSprite(G_basic_font_ + character * 16, memory, CHARACTER_WIDTH_, CHARACTER_HEIGHT_);

        // Add the number of bytes to move to the next location in graphic memory.
        memory += 2;

        // Move to the next position in the input string.
        ++position;
    }
}

#else

#if defined(ALLEGRO5) || defined(ALLEGRO4)
ALLEGRO_FONT* defaultFont_ = NULL;
#endif

void drawString(u16 x, u16 y, u8 scaleFactor, const u8* string, ALLEGRO_COLOR textColour)
{
#ifdef ALLEGRO4
    textout_ex(screen, defaultFont_, string, x * scaleFactor, y * scaleFactor, textColour, -1);
#else
    al_draw_text(defaultFont_, textColour, x * scaleFactor, y * scaleFactor, 0, string);
#endif
}

i8 initFonts(const u8* fontPath)
{
    if (fontPath == NULL)
    {
        return -1;
    }

#ifdef ALLEGRO4
    if (exists(fontPath))
    {
        defaultFont_ = load_font(fontPath, NULL, NULL);
    }
    else
    {
        defaultFont_ = NULL;
    }

#else
    defaultFont_ = al_load_font(fontPath, 14 * scaleFactor, 0);
#endif

    if (defaultFont_ == NULL)
    {
        return -2;
    }
    else
    {
        return 0;
    }
}

void destroyFonts()
{
#ifdef ALLEGRO4
    destroy_font(defaultFont_);
#else
    al_destroy_font(defaultFont_);
#endif
}

#endif

void convertNumberToString(u16 input, u8* output)
{
    // Need to add 48 to each number to actually display the correct number on screen.
    u8 nextDigit = FALSE;

    if (input >= 10000)
    {
        *output = (input / 10000) + ASCII_TO_NUMBER_OFFSET_;
        ++output;
        input = (input % 10000);
        nextDigit = TRUE;
    }

    if (input >= 1000 || nextDigit)
    {
        *output = (input / 1000) + ASCII_TO_NUMBER_OFFSET_;
        ++output;
        input = (input % 1000);
        nextDigit = TRUE;
    }

    if (input >= 100 || nextDigit)
    {
        *output = (input / 100) + ASCII_TO_NUMBER_OFFSET_;
        ++output;
        input = (input % 100);
        nextDigit = TRUE;
    }

    if (input >= 10 || nextDigit)
    {
        *output = (input / 10) + ASCII_TO_NUMBER_OFFSET_;
        ++output;
        input = (input % 10);
        nextDigit = TRUE;
    }

    if (input < 10 || nextDigit)
    {
        *output = input + ASCII_TO_NUMBER_OFFSET_;
        ++output;
    }

    // Add the null terminator at the end.
    *output = '\0';
}

#ifdef CPC
void drawScore(u16 score, u8 scoreStartPosition, u8 yPosition)
#else
void drawScore(i32 score, u16 scoreStartPosition, u16 yPosition, u8 scaleFactor, ALLEGRO_COLOR textColour)
#endif
{
#ifdef CPC

    static u8 scoreText[6];

    convertNumberToString(score, scoreText);

    // Draw all zeros (there is an extra 0 so that scores can be bigger than the are actually stored).
    drawString(scoreStartPosition, yPosition, "000000");

    // Determines where the score is drawn so there are 0s in the right place.
    if (score < 100)
    {
        scoreStartPosition += 6;
    }
    else if (score < 1000)
    {
        scoreStartPosition += 4;
    }
    else if (score < 10000)
    {
        scoreStartPosition += 2;
    }

    drawString(scoreStartPosition, yPosition, scoreText);

#else

    static u8 scoreText[7];

#if _MSC_VER > 1200
    sprintf_s(scoreText, 7, "%06d", score * 10);
#else
    sprintf(scoreText, "%06d", score * 10);
#endif

    drawString(scoreStartPosition, yPosition, scaleFactor, scoreText, textColour);

#endif
}
