#ifndef SPRITEUTIL_H
#define SPRITEUTIL_H

#ifndef CPC

#ifdef ALLEGRO5
#include <allegro5/allegro.h>
#else
#include <allegro.h>
#endif

#include "GameTypes.h"

// Converts the mode 0 display byte to the pixel 0 pen in mode 0.
u8 displayToPixel0(u8 displayByte);

// Converts the mode 0 display byte to the pixel 1 pen in mode 0.
u8 displayToPixel1(u8 displayByte);

// Converts the hardware colour pen value to the equivalent firmware colour value.
u8 hardwareToFirmwareColour(u8 hardwareColour);

// Convert from the firmware colour value to the equivalent ALLEGRO_COLOR value.
ALLEGRO_COLOR firmwareToAllegroColour(u8 paletteValue);

// Constructs an ALLEGRO_BITMAP from a cpctelera graphic in display byte form.
#ifdef ALLEGRO5
ALLEGRO_BITMAP* constructBitmap(const u8* displayBytes, u8 displayByteCount, u8 width, u8 height, u8 targetWidth, const u8* palette, u8 transparencyType);
#else
BITMAP* constructBitmap(const u8* displayBytes, u8 displayByteCount, u8 width, u8 height, u8 targetWidth, const u8* palette);
#endif

// Converts from a pen value in the palette to an ALLEGRO_COLOR value.
ALLEGRO_COLOR penToColour(u8 pen, const u8* palette);

#endif

#endif
