#ifndef SPRITESET_H
#define SPRITESET_H

#ifdef ALLEGRO5
#include <allegro5/allegro.h>
#include "SpriteUtil.h"
#elif ALLEGRO4
#include <allegro.h>
#include "SpriteUtil.h"
#endif

#include "GameTypes.h"
#include "sprites/EnvironmentSprites.h"
#include "sprites/InteractableSprites.h"
#include "sprites/HudSprites.h"
#include "sprites/ItemSprites.h"
#include "sprites/PlayerSprites.h"
#include "sprites/TileSprites.h"

// The number of tile sprites in the tile sprite set.
#define TILE_SPRITE_COUNT 15

// The number of item sprites in the item sprite set.
#define ITEM_SPRITE_COUNT 13

// The number of interactable sprites in the interactable sprite set.
#define INTERACTABLE_SPRITE_COUNT 10

// The number of environment sprites in the environment sprite set.
#define ENVIRONMENT_SPRITE_COUNT 10

// The number of player sprites in the player sprite set.
#define PLAYER_SPRITE_COUNT 8

// The number of hud sprites in the hud sprite set.
#define HUD_SPRITE_COUNT 6

// Array for accessing tile sprites in CPC format.
extern const u8* const tileSprites[TILE_SPRITE_COUNT];

// Array for accessing item sprites in CPC format.
extern const u8* const itemSprites[ITEM_SPRITE_COUNT];

// Array for accessing interactable sprites in CPC format.
extern const u8* const interactableSprites[INTERACTABLE_SPRITE_COUNT];

// Array for accessing environment sprites in CPC format.
extern const u8* const environmentSprites[ENVIRONMENT_SPRITE_COUNT];

// Array for accessing player sprites in CPC format.
extern const u8* const playerSprites[PLAYER_SPRITE_COUNT];

#ifndef CPC

// Array index of the health sprite in the hud sprites array.
#define HUD_SPRITE_HEALTH 0

// Array index of the lives sprite in the hud sprites array.
#define HUD_SPRITE_LIVES 1

// Array index of the red key sprite in the hud sprites array.
#define HUD_SPRITE_KEY_RED 2

// Array index of the green key sprite in the hud sprites array.
#define HUD_SPRITE_KEY_GREEN 3

// Array index of the yellow key sprite in the hud sprites array.
#define HUD_SPRITE_KEY_YELLOW 4

// Array index of the paint sprite in the hud sprites array.
#define HUD_SPRITE_PAINT 5

// Array for accessing tile sprites in Allegro.
extern ALLEGRO_BITMAP* allegroTileSprites[TILE_SPRITE_COUNT];

// Array for accessing item sprites in Allegro.
extern ALLEGRO_BITMAP* allegroItemSprites[ITEM_SPRITE_COUNT];

// Array for accessing interactable sprites in Allegro.
extern ALLEGRO_BITMAP* allegroInteractableSprites[INTERACTABLE_SPRITE_COUNT];

// Array for accessing environment sprites in Allegro.
extern ALLEGRO_BITMAP* allegroEnvironmentSprites[ENVIRONMENT_SPRITE_COUNT];

// Array for accessing player sprites in Allegro.
extern ALLEGRO_BITMAP* allegroPlayerSprites[PLAYER_SPRITE_COUNT];

// Array for accessing hud sprites in Allegro.
extern ALLEGRO_BITMAP* allegroHudSprites[HUD_SPRITE_COUNT];

// Initialise the all the sprites into ALLEGRO_BITMAP objects.
void initAllAllegroSpriteSets(const u8* palette, u8 transparencyType);

// Initialise the tile size sprites into ALLEGRO_BITMAP objects.
void initAllegroSpriteSet(ALLEGRO_BITMAP** allegroBitmaps, u8** sprites, u8 width, u8 height, u8 count, const u8* palette, u8 transparencyType);

// Destroys all the ALLEGRO_BITMAP objects in the allegro sprites array.
void destroyAllAllegroSpriteSets();

// Destroys all the ALLEGRO_BITMAP in the specified array.
void destroyAllegroSpriteSet(ALLEGRO_BITMAP** sprites, u8 count);

#endif

#endif
