#include "SpriteSet.h"

const u8* const tileSprites[TILE_SPRITE_COUNT] =
{
    G_tile_rock1,
    G_tile_wall1_white,
    G_tile_wall1_red,
    G_tile_wall1_yellow,
    G_tile_wall1_blue,
    G_tile_wall1_green,
    G_tile_wall1_lime,
    G_tile_wall1_purple,
    G_tile_wall1_brown,
    G_tile_wall1_red_blue,
    G_tile_wall1_yellow_green,
    G_tile_wall1_yellow_blue,
    G_tile_wall1_yellow_red,
    G_tile_wall1_purple_brown,
    G_tile_wall1_yellow_red_green_blue,
};

const u8* const itemSprites[ITEM_SPRITE_COUNT] =
{
    G_item_key_red,
    G_item_key_green,
    G_item_key_yellow,
    G_item_banana,
    G_item_eggplant,
    G_item_watermelon,
    G_item_carrot,
    G_item_paint_white,
    G_item_paint_red,
    G_item_paint_yellow,
    G_item_paint_blue,
    G_item_paint_green,
    G_item_paint_reset,
};

const u8* const interactableSprites[INTERACTABLE_SPRITE_COUNT] =
{
    G_interactable_white_red,
    G_interactable_white_blue,
    G_interactable_yellow_blue,
    G_interactable_red_blue,
    G_interactable_red_green,
    G_interactable_green_yellow,
    G_interactable_exit,
    G_interactable_door_red,
    G_interactable_door_green,
    G_interactable_door_yellow,
};

const u8* const environmentSprites[ENVIRONMENT_SPRITE_COUNT] =
{
    G_environment_ground,
    G_environment_chasm,
    G_environment_spike_white,
    G_environment_spike_red,
    G_environment_spike_yellow,
    G_environment_spike_blue,
    G_environment_spike_green,
    G_environment_plus,
    G_environment_ground_white,
    G_environment_ground_lines,
};

const u8* const playerSprites[PLAYER_SPRITE_COUNT] =
{
    G_player_right,
    G_player_left,
    G_player_down,
    G_player_up,
    G_player_right_painted,
    G_player_left_painted,
    G_player_down_painted,
    G_player_up_painted,
};

const u8* const hudSprites[HUD_SPRITE_COUNT] =
{
    G_hud_health,
    G_hud_lives,
    G_hud_key_red,
    G_hud_key_green,
    G_hud_key_yellow,
    G_hud_paint
};

#ifndef CPC

// Array for accessing tile sprites in Allegro.
ALLEGRO_BITMAP* allegroTileSprites[TILE_SPRITE_COUNT];

// Array for accessing item sprites in Allegro.
ALLEGRO_BITMAP* allegroItemSprites[ITEM_SPRITE_COUNT];

// Array for accessing interactable sprites in Allegro.
ALLEGRO_BITMAP* allegroInteractableSprites[INTERACTABLE_SPRITE_COUNT];

// Array for accessing environment sprites in Allegro.
ALLEGRO_BITMAP* allegroEnvironmentSprites[ENVIRONMENT_SPRITE_COUNT];

// Array for accessing player sprites in Allegro.
ALLEGRO_BITMAP* allegroPlayerSprites[PLAYER_SPRITE_COUNT];

// Array for accessing hud sprites in Allegro.
ALLEGRO_BITMAP* allegroHudSprites[HUD_SPRITE_COUNT];

void initAllAllegroSpriteSets(const u8* palette, u8 transparencyType)
{
    initAllegroSpriteSet(allegroTileSprites, (u8**)tileSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, TILE_SPRITE_COUNT, palette, transparencyType);
    initAllegroSpriteSet(allegroItemSprites, (u8**)itemSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, ITEM_SPRITE_COUNT, palette, transparencyType);
    initAllegroSpriteSet(allegroInteractableSprites, (u8**)interactableSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, INTERACTABLE_SPRITE_COUNT, palette, transparencyType);
    initAllegroSpriteSet(allegroEnvironmentSprites, (u8**)environmentSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, ENVIRONMENT_SPRITE_COUNT, palette, transparencyType);
    initAllegroSpriteSet(allegroPlayerSprites, (u8**)playerSprites, TILE_WIDTH_BYTES, TILE_HEIGHT, PLAYER_SPRITE_COUNT, palette, transparencyType);
    initAllegroSpriteSet(allegroHudSprites, (u8**)hudSprites, 3, 8, HUD_SPRITE_COUNT, palette, transparencyType);
}

void initAllegroSpriteSet(ALLEGRO_BITMAP** allegroBitmaps, u8** sprites, u8 width, u8 height, u8 count, const u8* palette, u8 transparencyType)
{
    u8 i = 0;

    for (i = 0; i < count; ++i)
    {
#ifdef ALLEGRO4
        allegroBitmaps[i] = constructBitmap(sprites[i], width * height, width, height, width * 2, palette);
#else
        allegroBitmaps[i] = constructBitmap(sprites[i], width * height, width, height, width * 2, palette, transparencyType);
#endif
    }
}

void destroyAllAllegroSpriteSets()
{
    destroyAllegroSpriteSet(allegroTileSprites, TILE_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroItemSprites, ITEM_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroInteractableSprites, INTERACTABLE_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroEnvironmentSprites, ENVIRONMENT_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroPlayerSprites, PLAYER_SPRITE_COUNT);
    destroyAllegroSpriteSet(allegroHudSprites, HUD_SPRITE_COUNT);
}

void destroyAllegroSpriteSet(ALLEGRO_BITMAP** sprites, u8 count)
{
    u8 i = 0;

    for (i = 0; i < count; ++i)
    {
#ifdef ALLEGRO4
        destroy_bitmap(sprites[i]);
#else
        al_destroy_bitmap(sprites[i]);
#endif
    }
}

#endif
