#ifndef PALETTE_H
#define PALETTE_H

#ifdef CPC
#include <cpctelera.h>
#else
#include <string.h>
#include "SpriteSet.h"
#endif
#include "GameTypes.h"
#include "Map.h"
#include "Player.h"

// The number of colours in the CPC palette.
#define COLOUR_COUNT 16

// The position of bright yellow in the initial palette.
#define PALETTE_POSITION_BRIGHT_YELLOW 5

// The position of bright red in the initial palette.
#define PALETTE_POSITION_BRIGHT_RED 6

// The position of bright white in the initial palette.
#define PALETTE_POSITION_BRIGHT_WHITE 7

// The position of bright white 2 in the initial palette.
#define PALETTE_POSITION_BRIGHT_WHITE_2 8

// The position of bright blue in the initial palette.
#define PALETTE_POSITION_BRIGHT_BLUE 9

// The position of red in the initial palette.
#define PALETTE_POSITION_RED 10

// The position of green in the initial palette.
#define PALETTE_POSITION_GREEN 11

// The position of orange in the initial palette.
#define PALETTE_POSITION_ORANGE 12

// The position of magenta in the initial palette.
#define PALETTE_POSITION_MAGENTA 13

// The position of yellow in the initial palette.
#define PALETTE_POSITION_YELLOW 14

// The position of bright green in the initial palette.
#define PALETTE_POSITION_BRIGHT_GREEN 15

// The initial palette defining the colours that will be used to draw the graphics in the game.
#ifdef CPC
extern const u8 initialPalette[COLOUR_COUNT];
#else
extern u8 initialPalette[COLOUR_COUNT];
#endif

// The palette defining the colours that will be used to draw the graphics in the game and is updated by interactions in the game.
extern u8 gamePalette[COLOUR_COUNT];

#ifndef CPC
// The type of transparency used when constructing sprites.
extern u8 transparencyType;
#endif

// Initialise the game palette values to the initial palette.
void initPalette();

// Switch any match for the before colour to the after colour.
void switchColour(u8 beforeColour, u8 afterColour);

// Switch colours in the palette based on the colour at a position in the palette.
// This means that the most recent colour in the palette will be used instead of the inital palette colour.
void switchColourByPosition(u8 beforePosition, u8 afterPosition);

// Update the palette either with a palette switch or on Allegro by destroying and recreating the bitmaps with the current game palette.
void updatePalette();

#endif
