#ifndef MENU_H
#define MENU_H

#ifdef ALLEGRO4
    #include <allegro.h>
#elif ALLEGRO5
    #include <allegro5/allegro.h>
#else
    #include <cpctelera.h>
#endif

#include "Game.h"
#include "GameTypes.h"
#include "Keys.h"
#include "Text.h"
#include "Palette.h"
#include "Version.h"

// Sets up the main menu and runs the menu loop.
#ifdef ALLEGRO5
void runMenu(ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath);
#else
void runMenu();
#endif

// Draws the main menu on the screen.
void drawMenu();

#ifdef ALLEGRO5
// Sets up the event queue for allegro to start listening to events in the menu.
void setupMenuEventQueue(ALLEGRO_EVENT_QUEUE** eventQueue);
#endif

// Displays choices for the user to choose the keyboard/joystick controls for the game.
#ifdef ALLEGRO4
void rebindControls();
#elif ALLEGRO5
void rebindControls(ALLEGRO_EVENT_QUEUE** eventQueue);
#endif

#ifdef ALLEGRO4
// Reads the key from the user and returns an Allegro 4 scan code.
u8 readKeyScanCode();
#endif

#ifdef ALLEGRO5
// Get the user pressed key for rebind/redefine using Allegro.
u16 getKeyAllegro(ALLEGRO_EVENT_QUEUE** menuEventQueue);
#endif

// Displays the name of a control and allows the user to enter the new control for rebinding.
#ifdef ALLEGRO4
int choseNextControl(u16 x, u16 y, u8* string, ALLEGRO_COLOR textColour);
#elif ALLEGRO5
int choseNextControl(u16 x, u16 y, u8* string, ALLEGRO_COLOR textColour, ALLEGRO_EVENT_QUEUE** eventQueue);
#endif

#ifdef CPC
// Displays choices for the user to choose the keyboard/joystick controls for the game.
void rebindControls();

// Get the user pressed key for rebind/redefine key controls by ranaldo.
cpct_keyID getKey();
#endif

// Runs the full game session and displays victory or defeat based on outcome.
#ifdef ALLEGRO5
void runFullGame(ALLEGRO_EVENT_QUEUE** eventQueue);
#else
void runFullGame();
#endif

// Displays either victorious or game over depending on if the user completes the game or not.
#ifdef ALLEGRO5
void displayEndScreen(ALLEGRO_EVENT_QUEUE** eventQueue);
#else
void displayEndScreen();
#endif

// Displays the current high scores on the screen in a list.
#ifdef ALLEGRO5
void displayHighScores(ALLEGRO_EVENT_QUEUE** eventQueue);
#else
void displayHighScores();
#endif

// Initialise the high score values.
void initHighScores();

#ifdef ALLEGRO5
// Update the high scores if the player has a high score.
void updateHighScores(ALLEGRO_EVENT_QUEUE** eventQueue);
#else
// Update the high scores if the player has a high score.
void updateHighScores();
#endif

#ifdef CPC
// Allows the user to enter letters to form a word.
void enterWord(u8* word, u8 maxLength);
#elif ALLEGRO4
// Allows the user to enter letters to form a word.
void enterWordAllegro(u8* word, u8 maxLength, u16 x, u16 y);
#elif ALLEGRO5
// Allows the user to enter letters to form a word.
void enterWordAllegro(u8* word, u8 maxLength, u16 x, u16 y, ALLEGRO_EVENT_QUEUE** eventQueue);
#endif

#ifndef CPC
// Writes the high scores to a file.
void saveHighScores(const u8* filename);

// Reads the high scores from file.
void loadHighScores(const u8* filename);
#endif

#endif
