#ifndef KEYS_H
#define KEYS_H

#ifdef ALLEGRO4
#include <allegro.h>
#elif ALLEGRO5
#include <allegro5/allegro.h>
#elif CPC
#include <cpctelera.h>
#endif

#include "GameTypes.h"
#include "Text.h"

#ifndef CPC
#define cpct_keyID u16
#endif

typedef struct Keys Keys;

// Defines the controls used in the game.
struct Keys
{
    // Key values for setting custom controls.
    cpct_keyID up;
    cpct_keyID down;
    cpct_keyID left;
    cpct_keyID right;
    cpct_keyID action;
    cpct_keyID reset;
    cpct_keyID exit;

    // Flags indicating what controls are down.
    u8 controlFlags;
};

// Player selected controls for movement and actions.
extern Keys gameControls;

// Indicates whether the action key is currently pressed.
extern u8 actionKeyFlag;

// Control flag for up key detection.
#define CONTROL_UP_FLAG 1

// Control flag for down key detection.
#define CONTROL_DOWN_FLAG 2

// Control flag for left key detection.
#define CONTROL_LEFT_FLAG 4

// Control flag for right key detection.
#define CONTROL_RIGHT_FLAG 8

// Control flag for action key detection.
#define CONTROL_ACTION_FLAG 16

// Control flag for reset key detection.
#define CONTROL_RESET_FLAG 32

// Control flag for exit key detection.
#define CONTROL_EXIT_FLAG 64

// Saves the user specified controls to the game configuration file.
#ifdef ALLEGRO4
void saveControls();
#elif ALLEGRO5
void saveControls(ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath);
#endif

// Sets the default player controls for the game (if the user does not customise the controls).
#ifdef ALLEGRO5
void setDefaultKeys(ALLEGRO_CONFIG* config);
#else
void setDefaultKeys();
#endif

// Update the controls flags based on the keys that are currently pressed down.
#ifdef CPC
void readGameControls();
#elif ALLEGRO4
void readGameControlsAllegro4();
#else
void readGameControlsAllegro5(ALLEGRO_EVENT* allegroEvent);
#endif

#endif
