#include "Keys.h"

// Player selected controls for movement and actions.
Keys gameControls;

// Indicates whether the action key is currently pressed.
u8 actionKeyFlag;

#ifdef ALLEGRO4
void saveControls()
{
    // Setting control values in the game config file.
    set_config_int(NULL, "controls_left", gameControls.left);
    set_config_int(NULL, "controls_right", gameControls.right);
    set_config_int(NULL, "controls_up", gameControls.up);
    set_config_int(NULL, "controls_down", gameControls.down);
    set_config_int(NULL, "controls_action", gameControls.action);
    set_config_int(NULL, "controls_reset", gameControls.reset);
    set_config_int(NULL, "controls_exit", gameControls.exit);
}
#elif ALLEGRO5
void saveControls(ALLEGRO_CONFIG* config, ALLEGRO_PATH* configPath)
{
    // Setting control values in the game config file.
    static u8 keyText[4];
    convertNumberToString(gameControls.left, keyText);
    al_set_config_value(config, NULL, "controls_left", keyText);

    convertNumberToString(gameControls.right, keyText);
    al_set_config_value(config, NULL, "controls_right", keyText);

    convertNumberToString(gameControls.up, keyText);
    al_set_config_value(config, NULL, "controls_up", keyText);

    convertNumberToString(gameControls.down, keyText);
    al_set_config_value(config, NULL, "controls_down", keyText);

    convertNumberToString(gameControls.action, keyText);
    al_set_config_value(config, NULL, "controls_action", keyText);

    convertNumberToString(gameControls.reset, keyText);
    al_set_config_value(config, NULL, "controls_reset", keyText);

    convertNumberToString(gameControls.exit, keyText);
    al_set_config_value(config, NULL, "controls_exit", keyText);

    // Write out the config file with the update controls.
    al_save_config_file(al_path_cstr(configPath, '/'), config);
}
#endif

#ifdef ALLEGRO5
void setDefaultKeys(ALLEGRO_CONFIG* config)
#else
void setDefaultKeys()
#endif
{
#ifdef CPC

    gameControls.left = Key_CursorLeft;
    gameControls.right = Key_CursorRight;
    gameControls.up = Key_CursorUp;
    gameControls.down = Key_CursorDown;
    gameControls.action = Key_X;
    gameControls.reset = Key_Del;
    gameControls.exit = Key_Esc;

#else

    gameControls.left = ALLEGRO_KEY_LEFT;
    gameControls.right = ALLEGRO_KEY_RIGHT;
    gameControls.up = ALLEGRO_KEY_UP;
    gameControls.down = ALLEGRO_KEY_DOWN;
    gameControls.action = ALLEGRO_KEY_X;
    gameControls.reset = ALLEGRO_KEY_BACKSPACE;
    gameControls.exit = ALLEGRO_KEY_ESCAPE;

#endif

    // Read the configuration from the game.cfg file.
#ifdef ALLEGRO4
    gameControls.left = get_config_int(NULL, "controls_left", ALLEGRO_KEY_LEFT);
    gameControls.right = get_config_int(NULL, "controls_right", ALLEGRO_KEY_RIGHT);
    gameControls.up = get_config_int(NULL, "controls_up", ALLEGRO_KEY_UP);
    gameControls.down = get_config_int(NULL, "controls_down", ALLEGRO_KEY_DOWN);
    gameControls.action = get_config_int(NULL, "controls_action", ALLEGRO_KEY_X);
    gameControls.reset = get_config_int(NULL, "controls_reset", ALLEGRO_KEY_BACKSPACE);
    gameControls.exit = get_config_int(NULL, "controls_exit", ALLEGRO_KEY_ESCAPE);

#elif ALLEGRO5

    if (al_get_config_value(config, NULL, "controls_left") != NULL)
    {
        gameControls.left = atoi(al_get_config_value(config, NULL, "controls_left"));
    }

    if (al_get_config_value(config, NULL, "controls_right") != NULL)
    {
        gameControls.right = atoi(al_get_config_value(config, NULL, "controls_right"));
    }

    if (al_get_config_value(config, NULL, "controls_up") != NULL)
    {
        gameControls.up = atoi(al_get_config_value(config, NULL, "controls_up"));
    }

    if (al_get_config_value(config, NULL, "controls_down") != NULL)
    {
        gameControls.down = atoi(al_get_config_value(config, NULL, "controls_down"));
    }

    if (al_get_config_value(config, NULL, "controls_action") != NULL)
    {
        gameControls.action = atoi(al_get_config_value(config, NULL, "controls_action"));
    }

    if (al_get_config_value(config, NULL, "controls_reset") != NULL)
    {
        gameControls.reset = atoi(al_get_config_value(config, NULL, "controls_reset"));
    }

    if (al_get_config_value(config, NULL, "controls_exit") != NULL)
    {
        gameControls.exit = atoi(al_get_config_value(config, NULL, "controls_exit"));
    }
#endif
}

#ifdef CPC

void readGameControls()
{
    if (cpct_isKeyPressed(gameControls.left))
    {
        gameControls.controlFlags |= CONTROL_LEFT_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_LEFT_FLAG;
    }

    if (cpct_isKeyPressed(gameControls.right))
    {
        gameControls.controlFlags |= CONTROL_RIGHT_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_RIGHT_FLAG;
    }

    if (cpct_isKeyPressed(gameControls.up))
    {
        gameControls.controlFlags |= CONTROL_UP_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_UP_FLAG;
    }

    if (cpct_isKeyPressed(gameControls.down))
    {
        gameControls.controlFlags |= CONTROL_DOWN_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_DOWN_FLAG;
    }

    if (cpct_isKeyPressed(gameControls.action))
    {
        gameControls.controlFlags |= CONTROL_ACTION_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_ACTION_FLAG;

        // Action key flag can be reset now that player is no longer pressing the action key.
        actionKeyFlag = FALSE;
    }

    if (cpct_isKeyPressed(gameControls.reset))
    {
        gameControls.controlFlags |= CONTROL_RESET_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_RESET_FLAG;
    }

    if (cpct_isKeyPressed(gameControls.exit))
    {
        gameControls.controlFlags |= CONTROL_EXIT_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_EXIT_FLAG;
    }
}

#elif ALLEGRO4

void readGameControlsAllegro4()
{
    if (key[gameControls.left])
    {
        gameControls.controlFlags |= CONTROL_LEFT_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_LEFT_FLAG;
    }

    if (key[gameControls.right])
    {
        gameControls.controlFlags |= CONTROL_RIGHT_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_RIGHT_FLAG;
    }

    if (key[gameControls.up])
    {
        gameControls.controlFlags |= CONTROL_UP_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_UP_FLAG;
    }

    if (key[gameControls.down])
    {
        gameControls.controlFlags |= CONTROL_DOWN_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_DOWN_FLAG;
    }

    if (key[gameControls.action])
    {
        gameControls.controlFlags |= CONTROL_ACTION_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_ACTION_FLAG;

        // Action key flag can be reset now that player is no longer pressing the action key.
        actionKeyFlag = FALSE;
    }

    if (key[gameControls.reset])
    {
        gameControls.controlFlags |= CONTROL_RESET_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_RESET_FLAG;
    }

    if (key[gameControls.exit])
    {
        gameControls.controlFlags |= CONTROL_EXIT_FLAG;
    }
    else
    {
        gameControls.controlFlags &= ~CONTROL_EXIT_FLAG;
    }
}

#elif ALLEGRO5

void readGameControlsAllegro5(ALLEGRO_EVENT* allegroEvent)
{
    if (allegroEvent->type == ALLEGRO_EVENT_KEY_DOWN)
    {
        if (allegroEvent->keyboard.keycode == gameControls.left)
        {
            gameControls.controlFlags |= CONTROL_LEFT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.right)
        {
            gameControls.controlFlags |= CONTROL_RIGHT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.up)
        {
            gameControls.controlFlags |= CONTROL_UP_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.down)
        {
            gameControls.controlFlags |= CONTROL_DOWN_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.action)
        {
            gameControls.controlFlags |= CONTROL_ACTION_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.reset)
        {
            gameControls.controlFlags |= CONTROL_RESET_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.exit)
        {
            gameControls.controlFlags |= CONTROL_EXIT_FLAG;
        }
    }
    else if (allegroEvent->type == ALLEGRO_EVENT_KEY_UP)
    {
        if (allegroEvent->keyboard.keycode == gameControls.left)
        {
            gameControls.controlFlags &= ~CONTROL_LEFT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.right)
        {
            gameControls.controlFlags &= ~CONTROL_RIGHT_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.up)
        {
            gameControls.controlFlags &= ~CONTROL_UP_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.down)
        {
            gameControls.controlFlags &= ~CONTROL_DOWN_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.action)
        {
            gameControls.controlFlags &= ~CONTROL_ACTION_FLAG;

            // Action key flag can be reset now that player is no longer pressing the action key.
            actionKeyFlag = FALSE;
        }

        if (allegroEvent->keyboard.keycode == gameControls.reset)
        {
            gameControls.controlFlags &= ~CONTROL_RESET_FLAG;
        }

        if (allegroEvent->keyboard.keycode == gameControls.exit)
        {
            gameControls.controlFlags &= ~CONTROL_EXIT_FLAG;
        }
    }
    else if (allegroEvent->type == ALLEGRO_EVENT_DISPLAY_CLOSE)
    {
        // Update the exit flag to display the exit dialog on clicking the close button of the window.
        gameControls.controlFlags |= CONTROL_EXIT_FLAG;
    }
}

#endif
