#ifndef INVENTORY_H
#define INVENTORY_H

#include "GameTypes.h"
#include "Item.h"

// Red key inventory item flag.
#define INVENTORY_ITEM_KEY_RED 1

// Green key inventory item flag.
#define INVENTORY_ITEM_KEY_GREEN 2

// Yellow key inventory item flag.
#define INVENTORY_ITEM_KEY_YELLOW 4

// Inventory flags that define what inventory item the player is carrying.
extern u8 inventoryItems;

// Adds a specified item to the inventory from a given cell graphic value without flags.
void addItemToInventory(u8 item);

// Indicates if the inventory contains the specified item type.
u8 inventoryContainsItem(u8 item);

#endif
