#include "Inventory.h"

// Inventory flags that define what inventory item the player is carrying.
u8 inventoryItems;

void addItemToInventory(u8 item)
{
    // Only a maximum of 8 items for 8 bits supported.
    // TODO update when more items added.
    if (item <= ITEM_KEY_YELLOW)
    {
        // -1 so that the item starting at 1 will be 0 which will not change the first flag value from 1.
        inventoryItems |= 1 << (item - 1);
    }
}

u8 inventoryContainsItem(u8 item)
{
    if (item < 4)
    {
        // -1 so that the item starting at 1 will be 0 which will not change the first flag value from 1.
        // If the item matches the flag it will be 1.
        return inventoryItems & (1 << (item - 1));
    }
    else
    {
        return 0;
    }
}
