#ifndef INTERACTABLE_H
#define INTERACTABLE_H

#include "GameState.h"
#include "GameTypes.h"
#include "Inventory.h"
#include "Map.h"
#include "Palette.h"

#define INTERACTABLE_WHITE_RED 1
#define INTERACTABLE_WHITE_BLUE 2
#define INTERACTABLE_YELLOW_BLUE 3
#define INTERACTABLE_RED_BLUE 4
#define INTERACTABLE_RED_GREEN 5
#define INTERACTABLE_GREEN_YELLOW 6
#define INTERACTABLE_EXIT 7
#define INTERACTABLE_DOOR_RED 8
#define INTERACTABLE_DOOR_GREEN 9
#define INTERACTABLE_DOOR_YELLOW 10

// Activates an interactable in a particular cell and room (typically where the player is).
u8 activateInteractable(u8 x, u8 y, u8 roomX, u8 roomY, u8 sourceInteractbleType);

// Tests if an interactable is ready for it to be used or activated.
u8 isInteractableReady(u8 interactable);

// Determines if the player is carrying a key that matches the door based on the colours in the palette for the key and door.
u8 matchKeyToDoorByPalette(u8 interactablePalettePosition);

// Determines if the player can open the door and removes the key from the inventory if they can.
u8 canOpenDoor(u8 paletteColour);

#endif
