#include "Interactable.h"

u8 activateInteractable(u8 x, u8 y, u8 roomX, u8 roomY, u8 sourceInteractbleType)
{
    u8 cell = mapCell(x, y, roomX, roomY);

    // Only activate a cell if it is an interactable.
    if (cell & CELL_INTERACTABLE_FLAG)
    {
        u8 cellType = cell & CELL_GFX_RANGE;

        if (cellType == INTERACTABLE_WHITE_BLUE)
        {
            switchColourByPosition(PALETTE_POSITION_BRIGHT_WHITE, PALETTE_POSITION_BRIGHT_BLUE);
        }
        else if (cellType == INTERACTABLE_WHITE_RED)
        {
            switchColourByPosition(PALETTE_POSITION_BRIGHT_WHITE, PALETTE_POSITION_BRIGHT_RED);
        }
        else if (cellType == INTERACTABLE_YELLOW_BLUE)
        {
            switchColourByPosition(PALETTE_POSITION_BRIGHT_YELLOW, PALETTE_POSITION_BRIGHT_BLUE);
        }
        else if (cellType == INTERACTABLE_RED_BLUE)
        {
            switchColourByPosition(PALETTE_POSITION_BRIGHT_RED, PALETTE_POSITION_BRIGHT_BLUE);
        }
        else if (cellType == INTERACTABLE_RED_GREEN)
        {
            switchColourByPosition(PALETTE_POSITION_BRIGHT_RED, PALETTE_POSITION_GREEN);
        }
        else if (cellType == INTERACTABLE_GREEN_YELLOW)
        {
            switchColourByPosition(PALETTE_POSITION_GREEN, PALETTE_POSITION_BRIGHT_YELLOW);
        }
        else if (cellType == INTERACTABLE_EXIT)
        {
            levelState = LEVEL_COMPLETE;
            gameRunning = FALSE;
        }

        // Redraw the hud after a potential colour switch.
        // This ensures the hud sprites will have the correct colours after the switch.
        hudRedraw = TRUE;

        return TRUE;
    }

    // No interactable found so return false.
    return FALSE;
}

u8 isInteractableReady(u8 interactable)
{
    switch (interactable)
    {
        // Make sure the red door has a matching red key.
        case INTERACTABLE_DOOR_RED:
        {
            // Determine if the player has the matching key to open the door (based on the palette).
            return canOpenDoor(PALETTE_POSITION_BRIGHT_RED);
        }

        // Make sure the green door has a matching green key.
        case INTERACTABLE_DOOR_GREEN:
        {
            // Determine if the player has the matching key to open the door (based on the palette).
            return canOpenDoor(PALETTE_POSITION_GREEN);
        }

        // Make sure the yellow door has a matching yellow key.
        case INTERACTABLE_DOOR_YELLOW:
        {
            // Determine if the player has the matching key to open the door (based on the palette).
            return canOpenDoor(PALETTE_POSITION_BRIGHT_YELLOW);
        }
    }

    // Everything that is not a door is ready by default.
    return TRUE;
}

u8 matchKeyToDoorByPalette(u8 interactablePalettePosition)
{
    // Check if the player has a key and that the current colour of the door (in the palette) matches the colour of the key in the palette.
    if (inventoryItems & INVENTORY_ITEM_KEY_RED && gamePalette[interactablePalettePosition] == gamePalette[PALETTE_POSITION_BRIGHT_RED])
    {
        return INVENTORY_ITEM_KEY_RED;
    }
    else if (inventoryItems & INVENTORY_ITEM_KEY_GREEN && gamePalette[interactablePalettePosition] == gamePalette[PALETTE_POSITION_GREEN])
    {
        return INVENTORY_ITEM_KEY_GREEN;
    }
    else if (inventoryItems & INVENTORY_ITEM_KEY_YELLOW && gamePalette[interactablePalettePosition] == gamePalette[PALETTE_POSITION_BRIGHT_YELLOW])
    {
        return INVENTORY_ITEM_KEY_YELLOW;
    }

    return FALSE;
}

u8 canOpenDoor(u8 paletteColour)
{
    // Determine if there is a key that matches based on the palette (both key and door have the same colour).
    u8 matchFlag = matchKeyToDoorByPalette(paletteColour);

    if (matchFlag)
    {
        // Remove the key from the inventory on using the key.
        inventoryItems &= ~matchFlag;

        return TRUE;
    }

    return FALSE;
}