#include "Hud.h"

// X position of the first part of the hud.
#define HUD_X_POSITION_ 0

// X position of the second part of the hud.
#define HUD_X_POSITION_TWO_ 64

// Y position of the hud.
#define HUD_Y_POSITION_ 192

// Width of the first part of the hud.
#define HUD_WIDTH_ONE_ 64

// Width of the second part of the hud.
#define HUD_WIDTH_TWO_ 16

// Height of the hud.
#define HUD_HEIGHT_ 8

// Width of a hud item.
#define HUD_ITEM_WIDTH_BYTES_ 3

// Height of a hud item.
#define HUD_ITEM_HEIGHT_ 8

// X position of the game score.
#define HUD_SCORE_START_ 0

// Hud health X position.
#define HEALTH_START_ 15

// Hud lives count X position.
#define LIVES_START_ 24

// Hud paint X position.
#define PAINT_START_ 32

// Hud red key X position.
#define RED_KEY_START_ 40

// Hud green key X position.
#define GREEN_KEY_START_ 43

// Hud yellow key X position.
#define YELLOW_KEY_START_ 46

// Indicates if the hud is redrawn on the screen.
u8 hudRedraw = TRUE;

void drawHud()
{
    if (hudRedraw)
    {
        static u8 hudText[6];

#ifdef CPC

        // Draw the hud strip on the background in two parts.
        u8* memory = cpctm_screenPtr(CPCT_VMEM_START, HUD_X_POSITION_, HUD_Y_POSITION_);
        cpct_drawSolidBox(memory, cpctm_px2byteM0(0, 0), HUD_WIDTH_ONE_, HUD_HEIGHT_);
        cpct_drawSolidBox(memory + HUD_X_POSITION_TWO_, cpctm_px2byteM0(0, 0), HUD_WIDTH_TWO_, HUD_HEIGHT_);

#elif ALLEGRO4

        rectfill(screen, HUD_X_POSITION_, HUD_Y_POSITION_ * scaleFactor, (HUD_WIDTH_ONE_ + HUD_WIDTH_TWO_) * 4 * scaleFactor, (HUD_Y_POSITION_ + HUD_HEIGHT_) * scaleFactor, makecol(0, 0, 102));

#else

        al_draw_filled_rectangle(HUD_X_POSITION_, HUD_Y_POSITION_ * scaleFactor, (HUD_WIDTH_ONE_ + HUD_WIDTH_TWO_) * 4 * scaleFactor, (HUD_Y_POSITION_ + HUD_HEIGHT_) * scaleFactor, al_map_rgb(0, 0, 102));
        al_flip_display();

#endif

        // Draw the current game score at the bottom left.
#ifdef CPC
        drawScore(levelScore, HUD_SCORE_START_, HUD_Y_POSITION_);
#else
        drawScore(levelScore, HUD_SCORE_START_, HUD_Y_POSITION_, scaleFactor, al_map_rgb(255, 255, 255));
#endif

        // Player current health.
        convertNumberToString(player.health, hudText);

#ifdef CPC
        cpct_drawSprite(G_hud_health, memory + HEALTH_START_, HUD_ITEM_WIDTH_BYTES_, HUD_ITEM_HEIGHT_);
#elif ALLEGRO4
        stretch_sprite(screen, allegroHudSprites[HUD_SPRITE_HEALTH], HEALTH_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor);
#else
        al_draw_scaled_bitmap(allegroHudSprites[HUD_SPRITE_HEALTH], 0, 0, HUD_ITEM_WIDTH_BYTES_ * 2, HUD_ITEM_HEIGHT_, HEALTH_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor, 0);
#endif

#ifdef CPC
        drawString(HEALTH_START_ + HUD_ITEM_WIDTH_BYTES_ + 1, HUD_Y_POSITION_, hudText);
#else
        drawString((HEALTH_START_ + HUD_ITEM_WIDTH_BYTES_ + 1) * 4, HUD_Y_POSITION_, scaleFactor, hudText, al_map_rgb(255, 255, 255));
#endif

        // Player lives count.
        convertNumberToString(playerLives, hudText);

#ifdef CPC
        cpct_drawSprite(G_hud_lives, memory + LIVES_START_, HUD_ITEM_WIDTH_BYTES_, HUD_ITEM_HEIGHT_);
#elif ALLEGRO4
        stretch_sprite(screen, allegroHudSprites[HUD_SPRITE_LIVES], LIVES_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor);
#else
        al_draw_scaled_bitmap(allegroHudSprites[HUD_SPRITE_LIVES], 0, 0, HUD_ITEM_WIDTH_BYTES_ * 2, HUD_ITEM_HEIGHT_, LIVES_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor, 0);
#endif

#ifdef CPC
        drawString(LIVES_START_ + HUD_ITEM_WIDTH_BYTES_ + 1, HUD_Y_POSITION_, hudText);
#else
        drawString((LIVES_START_ + HUD_ITEM_WIDTH_BYTES_ + 1) * 4, HUD_Y_POSITION_, scaleFactor, hudText, al_map_rgb(255, 255, 255));
#endif

        // Paint colour indicator.
#ifdef CPC
        cpct_drawSprite(G_hud_paint, memory + PAINT_START_, HUD_ITEM_WIDTH_BYTES_, HUD_ITEM_HEIGHT_);
#elif ALLEGRO4
        stretch_sprite(screen, allegroHudSprites[HUD_SPRITE_PAINT], PAINT_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor);
#else
        al_draw_scaled_bitmap(allegroHudSprites[HUD_SPRITE_PAINT], 0, 0, HUD_ITEM_WIDTH_BYTES_ * 2, HUD_ITEM_HEIGHT_, PAINT_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor, 0);
#endif

        // Player inventory items.
        if (inventoryItems & INVENTORY_ITEM_KEY_RED)
        {
#ifdef CPC
            memory = cpctm_screenPtr(CPCT_VMEM_START, RED_KEY_START_, HUD_Y_POSITION_);
            cpct_drawSprite(G_hud_key_red, memory, HUD_ITEM_WIDTH_BYTES_, HUD_ITEM_HEIGHT_);
#elif ALLEGRO4
            stretch_sprite(screen, allegroHudSprites[HUD_SPRITE_KEY_RED], RED_KEY_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor);
#else
            al_draw_scaled_bitmap(allegroHudSprites[HUD_SPRITE_KEY_RED], 0, 0, HUD_ITEM_WIDTH_BYTES_ * 2, HUD_ITEM_HEIGHT_, RED_KEY_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor, 0);
#endif
        }

        if (inventoryItems & INVENTORY_ITEM_KEY_GREEN)
        {
#ifdef CPC
            memory = cpctm_screenPtr(CPCT_VMEM_START, GREEN_KEY_START_, HUD_Y_POSITION_);
            cpct_drawSprite(G_hud_key_green, memory, HUD_ITEM_WIDTH_BYTES_, HUD_ITEM_HEIGHT_);
#elif ALLEGRO4
            stretch_sprite(screen, allegroHudSprites[HUD_SPRITE_KEY_GREEN], GREEN_KEY_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor);
#else
            al_draw_scaled_bitmap(allegroHudSprites[HUD_SPRITE_KEY_GREEN], 0, 0, HUD_ITEM_WIDTH_BYTES_ * 2, HUD_ITEM_HEIGHT_, GREEN_KEY_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor, 0);
#endif
        }

        if (inventoryItems & INVENTORY_ITEM_KEY_YELLOW)
        {
#ifdef CPC
            memory = cpctm_screenPtr(CPCT_VMEM_START, YELLOW_KEY_START_, HUD_Y_POSITION_);
            cpct_drawSprite(G_hud_key_yellow, memory, HUD_ITEM_WIDTH_BYTES_, HUD_ITEM_HEIGHT_);
#elif ALLEGRO4
            stretch_sprite(screen, allegroHudSprites[HUD_SPRITE_KEY_YELLOW], YELLOW_KEY_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor);
#else
            al_draw_scaled_bitmap(allegroHudSprites[HUD_SPRITE_KEY_YELLOW], 0, 0, HUD_ITEM_WIDTH_BYTES_ * 2, HUD_ITEM_HEIGHT_, YELLOW_KEY_START_ * 4 * scaleFactor, HUD_Y_POSITION_ * scaleFactor, HUD_ITEM_WIDTH_BYTES_ * 4 * scaleFactor, HUD_ITEM_HEIGHT_ * scaleFactor, 0);
#endif
        }

        // Hud will not redraw until hudRedraw is set to true for the next update.
        hudRedraw = FALSE;
    }
}
