#ifndef GAMETYPES_H
#define GAMETYPES_H

#ifdef CPC
#include <types.h>
#endif

#ifndef CPC
// Cpctelera defines shortcut types in types.h that we are defining here for when using allegro.
typedef unsigned char       u8;
typedef signed char         i8;
typedef unsigned short      u16;
typedef signed short        i16;
typedef unsigned long      u32;
typedef signed long        i32;

// Cpctelera hw colour defines.
#define HW_WHITE 0x00
#define HW_SEA_GREEN 0x02
#define HW_PASTEL_YELLOW 0x03
#define HW_BLUE 0x04
#define HW_PURPLE 0x05
#define HW_CYAN 0x06
#define HW_PINK 0x07
#define HW_BRIGHT_YELLOW 0x0A
#define HW_BRIGHT_WHITE 0x0B
#define HW_BRIGHT_RED 0x0C
#define HW_BRIGHT_MAGENTA 0x0D
#define HW_ORANGE 0x0E
#define HW_PASTEL_MAGENTA 0x0F
#define HW_BRIGHT_GREEN 0x12
#define HW_BRIGHT_CYAN 0x13
#define HW_BLACK 0x14
#define HW_BRIGHT_BLUE 0x15
#define HW_GREEN 0x16
#define HW_SKY_BLUE 0x17
#define HW_MAGENTA 0x18
#define HW_PASTEL_GREEN 0x19
#define HW_LIME 0x1A
#define HW_PASTEL_CYAN 0x1B
#define HW_RED 0x1C
#define HW_MAUVE 0x1D
#define HW_YELLOW 0x1E
#define HW_PASTEL_BLUE 0x1F
#endif

#ifdef ALLEGRO5
typedef unsigned long long u64;
typedef signed long long   i64;
#endif

// Boolean true value 1.
#ifndef TRUE
#define TRUE 1
#endif

// Boolean false value 0.
#ifndef FALSE
#define FALSE 0
#endif

// Redefining Allegro 5 types for Allegro 4.
#ifdef ALLEGRO4
#define ALLEGRO_BITMAP BITMAP
#define ALLEGRO_COLOR i16
#define ALLEGRO_FONT FONT
#define ALLEGRO_SAMPLE SAMPLE
#define ALLEGRO_KEY_0 KEY_0
#define ALLEGRO_KEY_1 KEY_1
#define ALLEGRO_KEY_2 KEY_2
#define ALLEGRO_KEY_3 KEY_3
#define ALLEGRO_KEY_4 KEY_4
#define ALLEGRO_KEY_5 KEY_5
#define ALLEGRO_KEY_6 KEY_6
#define ALLEGRO_KEY_7 KEY_7
#define ALLEGRO_KEY_8 KEY_8
#define ALLEGRO_KEY_9 KEY_9
#define ALLEGRO_KEY_A KEY_A
#define ALLEGRO_KEY_B KEY_B
#define ALLEGRO_KEY_C KEY_C
#define ALLEGRO_KEY_D KEY_D
#define ALLEGRO_KEY_E KEY_E
#define ALLEGRO_KEY_F KEY_F
#define ALLEGRO_KEY_G KEY_G
#define ALLEGRO_KEY_H KEY_H
#define ALLEGRO_KEY_I KEY_I
#define ALLEGRO_KEY_J KEY_J
#define ALLEGRO_KEY_K KEY_K
#define ALLEGRO_KEY_L KEY_L
#define ALLEGRO_KEY_M KEY_M
#define ALLEGRO_KEY_N KEY_N
#define ALLEGRO_KEY_O KEY_O
#define ALLEGRO_KEY_P KEY_P
#define ALLEGRO_KEY_Q KEY_Q
#define ALLEGRO_KEY_R KEY_R
#define ALLEGRO_KEY_S KEY_S
#define ALLEGRO_KEY_T KEY_T
#define ALLEGRO_KEY_U KEY_U
#define ALLEGRO_KEY_V KEY_V
#define ALLEGRO_KEY_W KEY_W
#define ALLEGRO_KEY_X KEY_X
#define ALLEGRO_KEY_Y KEY_Y
#define ALLEGRO_KEY_Z KEY_Z
#define ALLEGRO_KEY_ENTER KEY_ENTER
#define ALLEGRO_KEY_PAD_ENTER KEY_ENTER_PAD
#define ALLEGRO_KEY_LEFT KEY_LEFT
#define ALLEGRO_KEY_RIGHT KEY_RIGHT
#define ALLEGRO_KEY_UP KEY_UP
#define ALLEGRO_KEY_DOWN KEY_DOWN
#define ALLEGRO_KEY_ESCAPE KEY_ESC
#define ALLEGRO_KEY_DELETE KEY_DEL
#define ALLEGRO_KEY_BACKSPACE KEY_BACKSPACE
#define ALLEGRO_KEY_SPACE KEY_SPACE
#define al_map_rgb makecol
#endif

#ifndef CPC
// The amount to scale the sprites based on screen resolution.
extern u8 scaleFactor;
#endif

#ifndef NULL
#define NULL 0
#endif

// The number of levels in the game.
#define LEVEL_COUNT 5

// The number of cells in the map grid.
#define MAP_CELL_COUNT 960

// Number of tiles that make up the screen vertically.
#define SCREEN_TILES_Y 12

// The button cell Y (index) on the screen.
#define SCREEN_BOTTOM_TILE_Y 11

// Number of tiles that make the screen horizontally.
#define SCREEN_TILES_X 20

// Number of tiles that make up the level vertically.
#define MAP_TILES_Y 24

// Number of tiles that make up the level horizontally.
#define MAP_TILES_X 40

// Height of a tile on screen.
#define TILE_HEIGHT 16

// Width of a tile on screen.
#define TILE_WIDTH_BYTES 4

// The possible bits that the cell graphic could be in.
#define CELL_GFX_RANGE 0x1F

// Cell empty flag.
#define CELL_EMPTY 0

// Flag indicating the cell is an item.
#define CELL_ITEM_FLAG 0x20

// Flag indicating the cell is an interactable.
#define CELL_INTERACTABLE_FLAG 0x40

// Flag indicating the cell is an environment.
#define CELL_ENVIRONMENT_FLAG 0x80

// Screen X dimension.
// Note: 80 = 160/2
#define SCREEN_X 80

// Screen Y dimension.
#define SCREEN_Y 200

// Screen Y dimension that only includes tiles (hud height isn't included).
#define SCREEN_Y_NO_HUD 192

// Right direction.
#define DIRECTION_RIGHT 0

// Left direction.
#define DIRECTION_LEFT 1

// Down direction.
#define DIRECTION_DOWN 2

// Up direction.
#define DIRECTION_UP 3

// Ready to start the level.
#define LEVEL_READY 0

// The level has been completed successfully.
#define LEVEL_COMPLETE 1

// The level has been exited via the exit dialog.
#define LEVEL_EXIT 2

// The player has died in the level.
#define LEVEL_DEATH 3

// All the levels in the game have been completed.
#define LEVEL_GAME_COMPLETE 4

// Player has died in a level and ran out of lives.
#define LEVEL_GAME_OVER 5

// X positions in (x,y) of cells in the grid.
extern const u8 xPositions[SCREEN_TILES_X];

// Y positions in (x,y) of cells in the grid.
extern const u8 yPositions[SCREEN_TILES_Y];

#endif
