#ifndef GAMESTATE_H
#define GAMESTATE_H

#include "Difficulty.h"
#include "GameTypes.h"

// Indicates if the game is currently running within the game loop.
extern u8 gameRunning;

// Indicates if the hud is redrawn on the screen.
extern u8 hudRedraw;

// Indicates the state of the level (or game) and whether it has ended (including success or failure).
extern u8 levelState;

// The current room that the player is in (0 to 3).
extern u8 currentRoom;

// The current room (x coordinate within the grid).
extern u8 currentRoomX;

// The current room (y coordinate within the grid).
extern u8 currentRoomY;

// Indicates the player has recently changed rooms.
extern u8 roomChange;

// The score for the whole game session.
extern u16 gameScore;

// The score including the progress for the current level.
extern u16 levelScore;

// The map index of the current map in the maps array.
extern u8 currentMap;

// The number of lives that the player has before they die.
extern u8 playerLives;

// Resets state values for the start of a new game session.
void resetGameSessionState();

#endif
