#include "GameState.h"

// Indicates if the game is currently running within the game loop.
u8 gameRunning = FALSE;

// Indicates the state of the level (or game) and whether it has ended (including success or failure).
u8 levelState = LEVEL_READY;

// The current room that the player is in (0 to 3).
u8 currentRoom = 0;

// The current room (x coordinate within the grid).
u8 currentRoomX = 0;

// The current room (y coordinate within the grid).
u8 currentRoomY = 0;

// Indicates the player has recently changed rooms.
u8 roomChange = FALSE;

// The score for the whole game session.
u16 gameScore = 0;

// The score including the progress for the current level.
u16 levelScore = 0;

// The map index of the current map in the maps array.
u8 currentMap = 0;

// The number of lives that the player has before they die.
u8 playerLives;

void resetGameSessionState()
{
    // Reset scores to 0.
    gameScore = 0;
    levelScore = 0;

    // Start the game from the first level.
    currentMap = 0;
    levelState = LEVEL_READY;

    // Sets the difficulty values for the game based on player chosen difficulty.
    setupDifficulty();

    // Difficulty must be set before setting player lives.
    playerLives = startingLivesCount;

    roomChange = FALSE;
}
