#ifndef GAME_H
#define GAME_H

#ifdef CPC
#include <cpctelera.h>
#elif ALLEGRO4
#include <allegro.h>
#elif ALLEGRO5
#include <allegro5/allegro.h>
#endif

#include "Dialog.h"
#include "GameState.h"
#include "Hud.h"
#include "Inventory.h"
#include "Keys.h"
#include "Map.h"
#include "Player.h"

// Runs the full game session and manages the levels in the game.
void runGameSession();

// Runs the game and the game loop.
void runGame();

// Read input from the player.
#ifdef ALLEGRO
void readInput(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent);
#else
void readInput();
#endif

// Displays the contents of the game on the screen as it changes.
void drawGame();

// This is where the processing of all the game logic happens.
void gameLogic();

#ifdef ALLEGRO4
// Draws the current framerate (updated once per second) on the top left of the screen.
void drawFps();
#endif

#endif
