#ifndef DIALOG_H
#define DIALOG_H

#ifdef CPC
#include <cpctelera.h>
#elif ALLEGRO4
#include <allegro.h>
#elif ALLEGRO5
#include <allegro5/allegro.h>
#include <allegro5/allegro_primitives.h>
#endif

#include "GameTypes.h"
#include "Keys.h"
#include "Text.h"

#ifdef CPC

// Displays a box to allow the player to choose if they want to exit the game or not.
u8 exitDialog();

#elif ALLEGRO4

// Displays a box with allegro 4 to allow the player to choose if they want to exit the game or not.
u8 exitDialogAllegro4();

#elif ALLEGRO5

// Displays a box with allegro 5 to allow the player to choose if they want to exit the game or not.
u8 exitDialogAllegro5(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent);

#endif

#endif
