#include "Dialog.h"

// The width of the exit dialog.
#ifdef CPC
#define EXIT_DIALOG_WIDTH_ 36
#elif ALLEGRO5
#define EXIT_DIALOG_WIDTH_ 90
#elif ALLEGRO4
#define EXIT_DIALOG_WIDTH_ 190
#endif

// The height of the exit dialog.
#define EXIT_DIALOG_HEIGHT_ 32

// The x position that the exit dialog is drawn from.
#define EXIT_DIALOG_X_ 88

// The y position that all dialogs start from.
#define DIALOG_Y_ 44

// The y position that all dialog text starts from.
#define DIALOG_Y_TEXT_ 49

#ifdef CPC

u8 exitDialog()
{
    u8* memory = cpctm_screenPtr(CPCT_VMEM_START, EXIT_DIALOG_X_, DIALOG_Y_);
    cpct_drawSolidBox(memory, cpctm_px2byteM0(0, 0) , EXIT_DIALOG_WIDTH_, EXIT_DIALOG_HEIGHT_);
    drawString(EXIT_DIALOG_X_ + 1, DIALOG_Y_TEXT_ + 3, "exit       y or n");

    // Break out of the loop once the user decides on their choice.
    while (1)
    {
        if (cpct_isKeyPressed(Key_Y))
        {
            return TRUE;
        }
        else if (cpct_isKeyPressed(Key_N))
        {
            return FALSE;
        }
    }
}

#elif ALLEGRO4

u8 exitDialogAllegro4()
{
    acquire_screen();
    rectfill(screen, EXIT_DIALOG_X_ * scaleFactor, DIALOG_Y_ * scaleFactor, (EXIT_DIALOG_X_ + EXIT_DIALOG_WIDTH_) * scaleFactor, (DIALOG_Y_ + EXIT_DIALOG_HEIGHT_) * scaleFactor, makecol(78, 9, 28));

    drawString(EXIT_DIALOG_X_ + 8, DIALOG_Y_TEXT_ + 6, scaleFactor, "EXIT   Y OR N", makecol(255, 255, 255));
    release_screen();

    while (1)
    {
        if (key[KEY_Y])
        {
            // Clear game controls to prevent exit dialog begin shown again.
            gameControls.controlFlags = 0;

            return TRUE;
        }
        else if (key[KEY_N])
        {
            // Clear game controls to prevent exit dialog begin shown again.
            gameControls.controlFlags = 0;

            return FALSE;
        }
    }
}

#elif ALLEGRO5

u8 exitDialogAllegro5(ALLEGRO_EVENT_QUEUE* eventQueue, ALLEGRO_EVENT* allegroEvent)
{
    al_draw_filled_rectangle(EXIT_DIALOG_X_ * scaleFactor, DIALOG_Y_ * scaleFactor, (EXIT_DIALOG_X_ + EXIT_DIALOG_WIDTH_) * scaleFactor, (DIALOG_Y_ + EXIT_DIALOG_HEIGHT_) * scaleFactor, al_map_rgb(78, 9, 28));
    drawString((EXIT_DIALOG_X_ + 8), (DIALOG_Y_TEXT_ + 6), scaleFactor, "EXIT   Y OR N", al_map_rgb(255, 255, 255));
    al_flip_display();

    while (1)
    {
        al_wait_for_event(eventQueue, allegroEvent);

        if (allegroEvent->type == ALLEGRO_EVENT_KEY_DOWN)
        {
            if (allegroEvent->keyboard.keycode == ALLEGRO_KEY_Y)
            {
                // Clear game controls to prevent exit dialog begin shown again.
                gameControls.controlFlags = 0;

                return TRUE;
            }
            else if (allegroEvent->keyboard.keycode == ALLEGRO_KEY_N)
            {
                // Clear game controls to prevent exit dialog begin shown again.
                gameControls.controlFlags = 0;

                return FALSE;
            }
        }
    }
}

#endif
