#ifndef CONFIG_H
#define CONFIG_H

#ifdef ALLEGRO4
    #include <allegro.h>
#elif ALLEGRO5
    #include <allegro5/allegro.h>
    #include <stdio.h>
#endif

#include "GameTypes.h"

#ifdef ALLEGRO4
// Locate the path to the configuration file.
// The file should be in the current directory or a parent directory.
u8 locateConfigPath(const u8* filename, u8* configPath);

#elif ALLEGRO5

// Locate the path to the configuration file.
// The file should be in the current directory or a parent directory.
ALLEGRO_PATH* locateConfigPath(const char* filename);
#endif

#ifndef CPC
// Calculate the scale factor for the game based on the screen resolution.
u8 calculateScaleFactor(u16 screenWidth, u16 screenHeight);
#endif

#endif
