#ifndef ACTOR_H
#define ACTOR_H

#include "GameTypes.h"
#include "Map.h"
#include "Object.h"

typedef struct Actor Actor;

struct Actor
{
    // Object containing position and velocity.
    Object object;

    // Number of hitpoints.
    u8 health;

    // Indicates whether the actor should be redrawn on screen.
    u8 redraw;

    // The type of actor (player, enemy).
    u8 actorType;
};

// Initialises common actor variables in the actor struct.
void initActor(Actor* actor, u8 x, u8 y);

#ifdef CPC
// Draws the actor on screen making use of the backbuffer to reduce flicker.
void drawActor(Actor* actor, u8* actorSprite);

#else

// Draws the actor on screen making use of the backbuffer to reduce flicker.
void drawActorAllegro(Actor* actor, ALLEGRO_BITMAP* actorSprite);

// Draws the cells in the map where the actor was previously.
void redrawActorPreviousPosition(Actor* actor);
#endif

// Indicates how many cells the actor of the specified cell type.
u8 actorOccuppyingCells(Actor* actor, u8 cellType);

#endif
