# KrampusHack 2024

This is my entry for KrampusHack 2024. Detail will be added as work progresses.

# Game

The game is written as a crossplatform game in C and includes variants for Allegro 4, Allegro 5 and cpctelera which provides support for the following platforms.

* Windows (Allegro 5)
* Linux (Allegro 5)
* Amstrad CPC (CPCtelera 1.5)
* Windows 95 (Allegro 4)
* MS-DOS (Allegro 4)

## Compiling Windows

1. Open the solution (krampu24.sln) with Visual Studio 2022.
2. Restore the allegro nuget packages (should happen automatically with the build)
3. Build krampu24 project

## Compiling Linux

Compiling under Linux requires the following packages installed:

* liballegro5-dev
* liballegro-ttf5-dev
* g++
* premake4

Run the following commands to build and execute the game:

1. premake4 gmake
2. make
3. cd build
4. ./krampu24

## Compiling Windows 95

1. Unpack the Allegro 4.2.3 distribution for MSVC6 to C:\include\allegro-4.2.3-msvc6 (http://cdn.allegro.cc/file/library/allegro-4.2.3/allegro-msvc6-4.2.3.zip)
2. Open the workspace (kru24w95.dsw) with Visual Studio 6.0
3. Build kru24w95 project

## Compiling MS-DOS

1. Unpack allegro 4.2.3 djgpp cross compiler for Windows to C:\include\djgpp (https://www.mrdictionary.net/allegro/20190618_Windows_DJGPP_Allegro423.zip)
2. Update C:\include\djgpp\env.bat for path: C:\include\djgpp
3. Install Premake 5 (https://github.com/premake/premake-core/releases/download/v5.0.0-beta2/premake-5.0.0-beta2-windows.zip)
4. Change to the kru24dos directory
5. premake5 gmake
6. C:\include\djgpp\env.bat
7. make

## Compiling CPC

To compile run either of the below commands from the game directory to build the game using the CPCtelera toolchain.

CPCtelera 1.5 ([GitHub development 04f767c](https://github.com/lronaldo/cpctelera/commit/04f767cf6dec99af47c47e4655c17504e6db7d89))

It is recommended to use the second command to ensure that it does a full build. A partial build often has often produced unexpected results projects in the past.

**make**

**make cleanall all**

## Running CPC

In order to run this it either write a dsk/cdt file to the appropriate media and load it into an Amstrad CPC464 or mount it in an emulator such as WinAPE.

Alternatively run the following command from the game directory to load the game into WinAPE using the CPCtelera script:

**cpct_winape game.dsk**
