#include "title.h"

//std::string Title::optionStrings[NUM_OPTIONS];

int Title::optionTextX[NUM_OPTIONS];
int Title::optionTextY[NUM_OPTIONS];

float Title::optionMarkerLeftX, Title::optionMarkerRightX;

int Title::targetedOption;
bool Title::exitOptionSelected;


void Title::Initialize()
{
    for(int i = 0; i < NUM_OPTIONS; i++)
    {
        optionTextX[i] = Display::WIDTH/2;
        optionTextY[i] = OPTION_TEXT_Y_BASE + i*OPTION_TEXT_Y_SPACING;
    }

    SetTargetedOption(OPTION_LAUNCH);
    exitOptionSelected = false;
}

void Title::Logic()
{

}

void Title::Input()
{
    if(Keyboard::keyHoldTicks[Keyboard::KEY_UP] == 1)
    {
        Title::AdjustTargetedOptionUp();
    }
    else if(Keyboard::keyHoldTicks[Keyboard::KEY_DOWN] == 1)
    {
        Title::AdjustTargetedOptionDown();
    }

    if(Keyboard::keyHoldTicks[Keyboard::KEY_ESC] == 1)
    {
        Title::SetTargetedOption(Title::OPTION_EXIT);
    }
    else if(/*Keyboard::keyHoldTicks[Keyboard::KEY_ENTER] == 1 ||*/
            Keyboard::keyHoldTicks[Keyboard::KEY_Z] == 1 ||
            Keyboard::keyHoldTicks[Keyboard::KEY_X] == 1 ||
            Keyboard::keyHoldTicks[Keyboard::KEY_C] == 1)
    {
        switch(Title::targetedOption)
        {
        case Title::OPTION_LAUNCH:
            Scene::ChangeScene(Scene::SCENE_OVERWORLD);
            break;
            /*
        case Title::OPTION_ARCHIVE:
            Scene::ChangeScene(Scene::SCENE_ARCHIVE);
            break;
            */
        case Title::OPTION_SETTINGS:
            Scene::ChangeScene(Scene::SCENE_SETTINGS);
            Audio::AddSfx(Audio::uiSelect0);
            break;
        case Title::OPTION_EXIT:
            exitOptionSelected = true;
            break;
        }
    }
}

void Title::Drawing()
{

    Hax::string_al_draw_text(FONTDEF_TITLE_TEXT, COLKEY_TITLE_TEXT, TITLE_TEXT_X, TITLE_TEXT_Y, ALLEGRO_ALIGN_CENTER, titleText);

    al_draw_filled_rectangle(0, optionTextY[Title::targetedOption], Display::WIDTH, optionTextY[Title::targetedOption] + OPTION_TEXT_Y_SPACING, COLKEY_TITLE_SELECTED_OPTION_HIGHLIGHT);

    for(int i = 0; i < Title::NUM_OPTIONS; i++)
    {
        Hax::string_al_draw_text(FONTDEF_TITLE_OPTIONS, COLKEY_TITLE_OPTION_TEXT,
                                 Title::optionTextX[i], Title::optionTextY[i],
                                 ALLEGRO_ALIGN_CENTRE, Title::optionStrings.at(i));
    }
}

void Title::RecalculateOptionMarkerX()
{
    optionMarkerLeftX = Hax::string_al_get_text_width(Font::monogram128, optionStrings.at(targetedOption))/2 + OPTION_MARKER_SPRITE_WIDTH + OPTION_MARKER_SPRITE_X_SPACING;
    optionMarkerRightX = Hax::string_al_get_text_width(Font::monogram128, optionStrings.at(targetedOption))/2 + OPTION_MARKER_SPRITE_X_SPACING;
}

void Title::AdjustTargetedOptionUp()
{
    if(targetedOption > FIRST_OPTION)
    {
        targetedOption --;
        RecalculateOptionMarkerX();
        Audio::AddSfx(Audio::uiSelect0);
    }
}

void Title::AdjustTargetedOptionDown()
{
    if(targetedOption < LAST_OPTION)
    {
        targetedOption ++;
        RecalculateOptionMarkerX();
        Audio::AddSfx(Audio::uiSelect0);
    }
}

void Title::SetTargetedOption(int whichOption)
{
    targetedOption = whichOption;
    RecalculateOptionMarkerX();
    //Audio::AddSfx(Audio::uiSelect0);
}
