#include "subship.h"

Subship::Subship()
{
    attachedShip = nullptr;
}

Subship::~Subship()
{
    attachedShip = nullptr;

    //std::cout << "Debug: Subship of type " << GetHullType() << " deleted." << std::endl;
}

void Subship::Initialize(int hull_type, Ship *attached_ship, bool is_righthand)
{
    Ship::Initialize();

    SetHullType(hull_type);

    SetAttachmentType(ShipIndex::subshipNeutralAttachmentType.at(GetHullType()), is_righthand);

    SetAttachedShip(attached_ship);
    SetAllXYPositions(attachedShip->GetXPosition() + attachmentXOffset, attachedShip->GetYPosition() + attachmentYOffset);
    SetMoveAngle(attachedShip->GetMoveAngle() + ShipIndex::subshipFormationRotationOffset.at(attachmentType) );
    SetAllSpriteRotations(GetMoveAngle());


    Emitter*mainEmitter = new Emitter();

    switch(GetHullType())
    {
        case ShipIndex::SUBSHIP_HULL_DORU:
            mainEmitter->Initialize(EmitterIndex::EMITTER_PRESET_DORU_MAIN);
            EnableAfterimages(ParticleIndex::PARTICLE_SUBSHIP_DORU_AFTERIMAGE);

        break;

        case ShipIndex::SUBSHIP_HULL_XIPHOS:
            EnableAfterimages(ParticleIndex::PARTICLE_SUBSHIP_XIPHOS_AFTERIMAGE);
        break;

        default:
            delete mainEmitter;
            mainEmitter = nullptr;
        break;
    }

    if(mainEmitter != nullptr)
    {
        mainEmitter->SetIsOnline(false);
        AddEmitter(mainEmitter);
    }


    SetEmitterXYOffset(0, -64);

    SetNumFrames(ShipIndex::SUBSHIP_NUM_FRAMES);

}

void Subship::Logic()
{
    Ship::Logic();

    SetXYPosition(attachedShip->GetXPosition() + attachmentXOffset, attachedShip->GetYPosition() + attachmentYOffset);
    SetMoveAngle(attachedShip->GetMoveAngle() + ShipIndex::subshipFormationRotationOffset.at(attachmentType) );

    SetSpriteRotation(GetMoveAngle());
    ///UpdateInterpolation();

    AfterimageUpdate(attachmentIsRighthand);

    for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end(); ++it)
    {
        (*it)->SetVolleyAngle(GetMoveAngle());
        (*it)->Logic();
    }
}

void Subship::Drawing()
{
    UpdateInterpolation();

    int flags = 0;
    if(attachmentIsRighthand)
        flags = ALLEGRO_FLIP_VERTICAL; // Yeah, not horizontal. It's weird, but the image is rotated 90 degrees CW in the resource png.

    al_draw_rotated_bitmap(Image::subshipSub[GetHullType()*ShipIndex::SUBSHIP_NUM_FRAMES + GetCurrentFrame()],
                            GetSpriteWidth()/2, GetSpriteHeight()/2,
                            GetXPosition(), GetYPosition(),
                            GetInterpolatedSpriteRotation(), flags);
    DebugDrawPosition();
}
