#include "stage.h"

int Stage::sectionNumber;
int Stage::sectionLength;
int Stage::sectionProgress;
bool Stage::inIntermission;
bool Stage::inFinalIntermission;

std::multimap<int, NPC*> Stage::sectionShipSchedule;
std::multimap<int, Particle*> Stage::sectionEffectsSchedule;
std::multimap<int, int> Stage::sectionEventsSchedule;

bool Stage::bossActive;
bool Stage::bossDefeated;
NPC* Stage::p_scheherazade;

void Stage::Initialize(int starting_section)
{
    sectionNumber = starting_section-1; // Quick hack to get around sectionNumber++ in logic.

    const int debugSkipStage = sectionNumber + 0;
    sectionNumber = debugSkipStage;

/// Comment out to disable debug:
///#define DEBUG_STAGE
#ifdef DEBUG_STAGE
    sectionNumber = -100;
#endif
    sectionLength = 0;
    sectionProgress = 0;
    inIntermission = true;
    inFinalIntermission = false;

    bossActive = false;
    bossDefeated = false;
    p_scheherazade = nullptr;
}

void Stage::Uninitialize()
{
    DeleteSectionSchedules();
}

void Stage::Logic()
{
    std::pair<std::multimap<int, NPC*>::iterator, std::multimap<int, NPC*>::iterator>scheduledShips;
    scheduledShips = Stage::sectionShipSchedule.equal_range(Stage::sectionProgress);
    for(std::multimap<int, NPC*>::iterator it = scheduledShips.first; it != scheduledShips.second;)
    {
        NPC::npcs.push_back(it->second);
        (*it).second->SetTrackedTarget(PC::pc);
        it = Stage::sectionShipSchedule.erase(it);
    }

    std::pair<std::multimap<int, Particle*>::iterator, std::multimap<int, Particle*>::iterator>scheduledEffects;
    scheduledEffects = Stage::sectionEffectsSchedule.equal_range(Stage::sectionProgress);
    for(std::multimap<int, Particle*>::iterator it = scheduledEffects.first; it != scheduledEffects.second;)
    {
        Particle::particles.push_back(it->second);
        it = Stage::sectionEffectsSchedule.erase(it);

        Audio::AddSfx(Audio::edgeAlert0);
    }

    std::pair<std::multimap<int, int>::iterator, std::multimap<int, int>::iterator>scheduledEvents;
    scheduledEvents = Stage::sectionEventsSchedule.equal_range(Stage::sectionProgress);
    for(std::multimap<int, int>::iterator it = scheduledEvents.first; it != scheduledEvents.second;)
    {
        switch((*it).second)
        {
            case STAGE_EVENT_TUTORIAL:
                Frame::InitTutorialFrameEvent();
            break;

            case STAGE_EVENT_ANTIGEN_WARNING:
                Frame::InitAntigenWarningFrameEvent();
            break;

            case STAGE_EVENT_SCHEHERAZADE_BATTLE_MODE:

                bossActive = true;

                for(std::vector<NPC*>::iterator it = NPC::npcs.begin(); it != NPC::npcs.end();)
                {
                    delete *it;
                    *it = nullptr;
                    it = NPC::npcs.erase(it);
                }

                p_scheherazade = new NPC();
                p_scheherazade->NPC::Initialize(ShipIndex::HULL_NPC_SCHEHERAZADE, Arena::TOP_WALL_MID, Arena::TOP_WALL-128, Arena::TOP_WALL_MID, Arena::TOP_WALL + 192);
                p_scheherazade->EnableBossProtocol();
                p_scheherazade->SetTrackedTarget(PC::pc);

                NPC::npcs.push_back(p_scheherazade);

                Arena::pursuitModeActive = true;
                Grid::gridScrollYSpeed *= 1.5;
                Grid::darkGridScrollYSpeed *= 1.5;
                Audio::AddSfx(Audio::boost0);
            break;
        }
        it = Stage::sectionEventsSchedule.erase(it);
    }

    if(bossActive == true)
    {
        if(! p_scheherazade->GetIsActive())
        {
            bossActive = false;
            bossDefeated = true;
            //std::cout << "debug skip to end" << std::endl;
            sectionProgress = sectionLength - Timer::LPS*3.0; // Skip to end.
        }

    }

    sectionProgress ++;
    if(sectionProgress > sectionLength)
    {
        sectionProgress = 0;
        DeleteSectionSchedules();

        if(inIntermission)
        {
            inIntermission = false;
            sectionNumber ++;

            //std::cout << "Init section " << sectionNumber << std::endl;

            switch(sectionNumber)
            {
            case -99:
                InitDebugSection();
                break;
            case 0:
                InitTutorialSection();
                break;
            case 1:
                InitSection1();
                break;
            case 2:
                InitSection2();
                break;
            case 3:
                InitSection3();
                break;
            }
        }
        else // !inIntermission
        {
            //std::cout << "Intermission init" << std::endl;
            if(bossDefeated)
            {
                inIntermission = true;
                inFinalIntermission = true;
                sectionLength = 300.0*Timer::LPS;
            }
            else
            {
                inIntermission = true;
                sectionLength = 6.0*Timer::LPS;
                Score::npcDestructionIdleLockedTicks = Timer::LPS*18.0;
            }
        }
    }
}

void Stage::Drawing()
{
    if(inIntermission)
    {
            al_draw_text(FONTDEF_INTERMISSION_HEADER, COLKEY_INTERMISSION_HEADER, INTERMISSION_HEADER_X, INTERMISSION_HEADER_Y, ALLEGRO_ALIGN_CENTER, "Tactics Evaluation");

            al_draw_text(FONTDEF_INTERMISSION_LABEL,  COLKEY_INTERMISSION_LABEL, INTERMISSION_LABEL_X, INTERMISSION_CRAFT_DESTROYED_LABEL_Y, ALLEGRO_ALIGN_RIGHT, "Craft Destroyed: ");
            Hax::string_al_draw_text(FONTDEF_INTERMISSION_LABEL,  COLKEY_INTERMISSION_VALUE, INTERMISSION_LABEL_X, INTERMISSION_CRAFT_DESTROYED_LABEL_Y, ALLEGRO_ALIGN_LEFT,  std::to_string(Score::npcsDestroyed));

            al_draw_text(FONTDEF_INTERMISSION_LABEL,  COLKEY_INTERMISSION_LABEL, INTERMISSION_LABEL_X, INTERMISSION_DAMAGE_RECEIVED_LABEL_Y, ALLEGRO_ALIGN_RIGHT, "  Hits Received: ");
            Hax::string_al_draw_text(FONTDEF_INTERMISSION_LABEL,  COLKEY_INTERMISSION_VALUE, INTERMISSION_LABEL_X, INTERMISSION_DAMAGE_RECEIVED_LABEL_Y, ALLEGRO_ALIGN_LEFT,  std::to_string(Score::pcHitsReceived));

            al_draw_text(FONTDEF_INTERMISSION_LABEL,  COLKEY_INTERMISSION_LABEL, INTERMISSION_LABEL_X, INTERMISSION_CHAIN_UPTIME_LABEL_Y, ALLEGRO_ALIGN_RIGHT,    "  Longest Chain: ");
            Hax::string_al_draw_text(FONTDEF_INTERMISSION_LABEL,  COLKEY_INTERMISSION_VALUE, INTERMISSION_LABEL_X, INTERMISSION_CHAIN_UPTIME_LABEL_Y, ALLEGRO_ALIGN_LEFT,  std::to_string(Score::recordNpcDestructionChain));

            if(inFinalIntermission)
            {
                al_draw_text(FONTDEF_INTERMISSION_HEADER, COLKEY_INTERMISSION_HEADER, FINAL_INTERMISSION_FOOTER_X, FINAL_INTERMISSION_FOOTER_Y1, ALLEGRO_ALIGN_CENTER, "ANTIGEN FLEET ELIMINATED");
                al_draw_text(FONTDEF_INTERMISSION_HEADER, COLKEY_INTERMISSION_HEADER, FINAL_INTERMISSION_FOOTER_X, FINAL_INTERMISSION_FOOTER_Y2, ALLEGRO_ALIGN_CENTER, "Mission complete!");

            }

    }
}

void Stage::AddNPC(int whichHullType, float x_pos, float y_pos, float x_dest, float y_dest, int spawn_time, int spawn_firing_delay)
{
    NPC*spawnNPC;
    spawnNPC = new NPC();
    spawnNPC->NPC::Initialize(whichHullType, x_pos, y_pos, x_dest, y_dest);

    // The following code just shunts the NPC's entire sprite behind the Arena boundaries if they are spawning from one of the walls.
    // Technically, this makes the spawning x/y position unfaithful to AddNPC()'s parameters, especially for larger ships.
    // Oh well.
    if(spawnNPC->GetXPosition() < 1)
        spawnNPC->SetAllXPositions(0 - spawnNPC->GetSpriteWidth()/2);
    else if(spawnNPC->GetXPosition() > Arena::WIDTH - 1)
        spawnNPC->SetAllXPositions(Arena::WIDTH + spawnNPC->GetSpriteWidth()/2);

    if(spawnNPC->GetYPosition() < 1)
        spawnNPC->SetAllYPositions(0 - spawnNPC->GetSpriteHeight()/2);
    else if(spawnNPC->GetYPosition() > Arena::HEIGHT - 1)
        spawnNPC->SetAllYPositions(Arena::HEIGHT + spawnNPC->GetSpriteHeight()/2);


    if(spawnNPC->GetXDestination() < 1)
        spawnNPC->SetXDestination(0 - spawnNPC->GetSpriteWidth());
    else if(spawnNPC->GetXDestination() > Arena::WIDTH - 1)
        spawnNPC->SetXDestination(Arena::WIDTH + spawnNPC->GetSpriteWidth());

    if(spawnNPC->GetYDestination() < 1)
        spawnNPC->SetYDestination(0 - spawnNPC->GetSpriteHeight());
    else if(spawnNPC->GetYDestination() > Arena::HEIGHT - 1)
        spawnNPC->SetYDestination(Arena::HEIGHT + spawnNPC->GetSpriteHeight());

    /*
    if(spawn_firing_delay < 0)
        spawnNPC->SetDefaultSpawnFiringDelay();
    else
        spawnNPC->SetSpawnFiringDelay(spawn_firing_delay);
    */

    sectionShipSchedule.insert(std::make_pair(spawn_time, spawnNPC));

}

void Stage::AddNPC(int whichHullType, float x_pos, float y_pos, float x_dest, float y_dest, int spawn_time)
{
    AddNPC(whichHullType, x_pos, y_pos, x_dest, y_dest, spawn_time, -1);
}

void Stage::AddEdgeWarning(float x_pos, float y_pos, int spawn_time)
{
    Particle*edgeWarning;
    edgeWarning = new Particle();
    edgeWarning->Particle::Initialize(ParticleIndex::PARTICLE_EDGE_WARNING, 0, 2*ALLEGRO_PI*(-0.25), EDGE_WARNING_EFFECT_LIFESPAN);
    edgeWarning->SetAllXYPositions(x_pos, y_pos);

    sectionEffectsSchedule.insert(std::make_pair(spawn_time, edgeWarning));
}

void Stage::AddStageEvent(int which_event, int spawn_time)
{
    sectionEventsSchedule.insert(std::make_pair(spawn_time, which_event));
}

void Stage::DeleteSectionSchedules()
{
    for(std::multimap<int, NPC*>::iterator it = sectionShipSchedule.begin(); it != sectionShipSchedule.end();)
    {
        delete it->second;
        it->second = nullptr;
        it = sectionShipSchedule.erase(it);
    }

    for(std::multimap<int, Particle*>::iterator it = sectionEffectsSchedule.begin(); it != sectionEffectsSchedule.end();)
    {
        delete it->second;
        it->second = nullptr;
        it = sectionEffectsSchedule.erase(it);
    }

    sectionEventsSchedule.clear();

}

void Stage::InitDebugSection()
{
    sectionLength = 1000*Timer::LPS;

    //AddEdgeWarning(Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,                                                           (4+0.0-EDGE_WARNING_EFFECT_LIFESPAN));

    //AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_OCELLUS,       Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_ANGELFISH,       Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid

    //AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_CROSS,   Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_MISSILE,   Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid

    //AddNPC(ShipIndex::HULL_NPC_PARTISAN,  Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid


    //AddNPC(ShipIndex::HULL_NPC_SUNFISH,   Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // TOP MID to BOTTOM MID
    //AddNPC(ShipIndex::HULL_NPC_SUNFISH,   Arena::BOTTOM_WALL_MID,  Arena::BOTTOM_WALL,    Arena::TOP_WALL_MID,        Arena::TOP_WALL, 1); // bottom mid to top mid
    //AddNPC(ShipIndex::HULL_NPC_SPIRIT,    Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_SPIRIT,    Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,      Arena::TOP_WALL_MID,  Arena::TOP_WALL, 1); // bottom mid to top mid
    //AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
    //AddNPC(ShipIndex::HULL_NPC_LUNARIAN,  Arena::TOP_WALL_MID,     Arena::TOP_WALL,       Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL, 1); // top mid to bottom mid
}

void Stage::InitTutorialSection()
{
    //std::cout << "huh" << std::endl;
    sectionLength = 30*Timer::LPS;
    sectionProgress = 0;

    const int w0 = 0.0;

    AddStageEvent(STAGE_EVENT_TUTORIAL, (w0+0.1)*Timer::LPS);
}

void Stage::InitSection1()
{
    sectionLength = 65*Timer::LPS;

    const int debugSkipTo = 0.0*Timer::LPS;
    sectionProgress = debugSkipTo;

    Audio::SetActiveBgm(Audio::s1s2Bgm, 0);

    const int w0 = 0;

    AddStageEvent(STAGE_EVENT_ANTIGEN_WARNING, (w0+3.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_SCHEHERAZADE, Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL, Arena::TOP_WALL_MID, Arena::TOP_WALL-256, (w0+5.0)*Timer::LPS);

    const int  w1 = 6;
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -128,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,        (w1+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -192,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID- 64, Arena::BOTTOM_WALL,        (w1+0.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -256,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w1+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -192,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID- 64, Arena::BOTTOM_WALL,        (w1+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -128,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,        (w1+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   - 64,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-192, Arena::BOTTOM_WALL,        (w1+2.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,        (w1+3.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_OCELLUS,   Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w1+4.0)*Timer::LPS);

    const int w2 = 13;
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +128,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,        (w2+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +192,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+ 64, Arena::BOTTOM_WALL,        (w2+0.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +256,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w2+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +192,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+ 64, Arena::BOTTOM_WALL,        (w2+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +128,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,        (w2+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   + 64,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+192, Arena::BOTTOM_WALL,        (w2+2.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,        (w2+3.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_OCELLUS,   Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w2+4.0)*Timer::LPS);

    const int w3 = 20;
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-200, Arena::BOTTOM_WALL,        (w3+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w3+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+200, Arena::BOTTOM_WALL,        (w3+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-200, Arena::BOTTOM_WALL,        (w3+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w3+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+200, Arena::BOTTOM_WALL,        (w3+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   -200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-200, Arena::BOTTOM_WALL,        (w3+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w3+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID   +200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+200, Arena::BOTTOM_WALL,        (w3+2.0)*Timer::LPS);

    const int w4 = 23;
    AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::TOP_WALL_MID   -200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-200, Arena::BOTTOM_WALL,        (w4+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,   Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w4+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::TOP_WALL_MID   +200,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+200, Arena::BOTTOM_WALL,        (w4+2.0)*Timer::LPS);

    const int w5 = 26;
    AddEdgeWarning(                       Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL-64,                                                            (w5+0.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +100, Arena::TOP_WALL,           (w5+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +100, Arena::TOP_WALL,           (w5+1.5)*Timer::LPS);

    AddEdgeWarning(                       Arena::BOTTOM_WALL_MID-200,   Arena::BOTTOM_WALL-64,                                                            (w5+3.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_SUNFISH,   Arena::BOTTOM_WALL_MID-200,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   -200, Arena::TOP_WALL,           (w5+3.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +100, Arena::TOP_WALL,           (w5+3.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+ 32,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   + 32, Arena::TOP_WALL,           (w5+4.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+164,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +164, Arena::TOP_WALL,           (w5+4.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +100, Arena::TOP_WALL,           (w5+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +100, Arena::TOP_WALL,           (w5+7.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::BOTTOM_WALL_MID+100,   Arena::BOTTOM_WALL,        Arena::TOP_WALL_MID   +100, Arena::TOP_WALL,           (w5+9.0)*Timer::LPS);

    const int w6 = 36;
    AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::RIGHT_WALL,            Arena::RIGHT_WALL_MID,     Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w6+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::LEFT_WALL,           Arena::LEFT_WALL_MID,      (w6+1.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_PARTISAN,  Arena::RIGHT_WALL,            Arena::TOP_WALL,           Arena::LEFT_WALL,           Arena::BOTTOM_WALL,        (w6+1.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_ANTLION,   Arena::RIGHT_WALL,            Arena::RIGHT_WALL_MID,     Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w6+4.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,   Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::LEFT_WALL,           Arena::LEFT_WALL_MID,      (w6+5.0)*Timer::LPS);

    const int w7 = 43;
    AddEdgeWarning(                           Arena::TOP_WALL_MID+128,      Arena::TOP_WALL+64,                                                           (w7+0.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::RIGHT_WALL,          Arena::BOTTOM_WALL,        (w7+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID+ 64,      Arena::TOP_WALL,           Arena::RIGHT_WALL     -128, Arena::BOTTOM_WALL,        (w7+0.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID+128,      Arena::TOP_WALL,           Arena::RIGHT_WALL     -256, Arena::BOTTOM_WALL,        (w7+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID+196,      Arena::TOP_WALL,           Arena::RIGHT_WALL     -384, Arena::BOTTOM_WALL,        (w7+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID+256,      Arena::TOP_WALL,           Arena::RIGHT_WALL     -512, Arena::BOTTOM_WALL,        (w7+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,  Arena::TOP_WALL_MID+320,      Arena::TOP_WALL,           Arena::RIGHT_WALL     -640, Arena::BOTTOM_WALL,        (w7+2.5)*Timer::LPS);

    const int w8 = 45;
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH, Arena::TOP_WALL_MID-128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,        (w8+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH, Arena::TOP_WALL_MID-128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,        (w8+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::TOP_WALL_MID+128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID +64, Arena::BOTTOM_WALL,        (w8+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH, Arena::TOP_WALL_MID-128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,        (w8+3.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_ANGELFISH, Arena::TOP_WALL_MID+128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,        (w8+4.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH, Arena::TOP_WALL_MID+128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,        (w8+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,       Arena::TOP_WALL_MID-128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID -64, Arena::BOTTOM_WALL,        (w8+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH, Arena::TOP_WALL_MID+128,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,        (w8+7.5)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w8+9.0)*Timer::LPS,  2.0*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID-256,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,        (w8+11.0)*Timer::LPS, 2.0*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID+256,      Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,        (w8+11.0)*Timer::LPS, 2.0*Timer::LPS);

    const int w9 = 58;
    AddNPC(ShipIndex::HULL_NPC_CROSS,     Arena::LEFT_WALL,             Arena::LEFT_WALL_MID - 52, Arena::RIGHT_WALL,          Arena::RIGHT_WALL_MID- 52, (w9+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CROSS,     Arena::RIGHT_WALL,            Arena::RIGHT_WALL_MID-180, Arena::LEFT_WALL,           Arena::LEFT_WALL_MID- 180, (w9+0.0)*Timer::LPS);


    /// BEEP BEEP BEEP Intermission/Summary  --> Stage 2 begins with pursuit encounter.

}

void Stage::InitSection2()
{
    sectionLength = 65*Timer::LPS;
    const int debugSkipTo = 0.0*Timer::LPS;
    sectionProgress = debugSkipTo;

    /// For testing

    const int w0 = 0;
    AddStageEvent(STAGE_EVENT_ANTIGEN_WARNING, (w0+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_SCHEHERAZADE, Arena::TOP_WALL_MID, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL+256, (w0+4.0)*Timer::LPS);

    AddEdgeWarning(Arena::LEFT_WALL +64, Arena::TOP_WALL + 128, (w0+5.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddEdgeWarning(Arena::RIGHT_WALL-64, Arena::TOP_WALL + 128, (w0+5.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+96,     Arena::RIGHT_WALL, Arena::TOP_WALL+96,             (w0+6.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+96,     Arena::LEFT_WALL,  Arena::TOP_WALL+96,             (w0+6.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+128,    Arena::RIGHT_WALL, Arena::TOP_WALL+128,            (w0+6.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+128,    Arena::LEFT_WALL,  Arena::TOP_WALL+128,            (w0+6.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+160,    Arena::RIGHT_WALL, Arena::TOP_WALL+160,            (w0+6.9)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+160,    Arena::LEFT_WALL,  Arena::TOP_WALL+160,            (w0+6.9)*Timer::LPS);

    AddEdgeWarning(Arena::LEFT_WALL +64, Arena::TOP_WALL + 256, (w0+6.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddEdgeWarning(Arena::RIGHT_WALL-64, Arena::TOP_WALL + 256, (w0+6.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+224,    Arena::RIGHT_WALL, Arena::TOP_WALL+224,            (w0+7.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+224,    Arena::LEFT_WALL,  Arena::TOP_WALL+224,            (w0+7.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+256,    Arena::RIGHT_WALL, Arena::TOP_WALL+256,            (w0+7.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+256,    Arena::LEFT_WALL,  Arena::TOP_WALL+256,            (w0+7.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+288,    Arena::RIGHT_WALL, Arena::TOP_WALL+288,            (w0+7.4)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+288,    Arena::LEFT_WALL,  Arena::TOP_WALL+288,            (w0+7.4)*Timer::LPS);

    AddEdgeWarning(Arena::LEFT_WALL +64, Arena::TOP_WALL + 384, (w0+6.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddEdgeWarning(Arena::RIGHT_WALL-64, Arena::TOP_WALL + 384, (w0+6.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+352,    Arena::RIGHT_WALL, Arena::TOP_WALL+352,            (w0+7.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+352,    Arena::LEFT_WALL,  Arena::TOP_WALL+352,            (w0+7.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+384,    Arena::RIGHT_WALL, Arena::TOP_WALL+384,            (w0+7.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+384,    Arena::LEFT_WALL,  Arena::TOP_WALL+384,            (w0+7.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::LEFT_WALL,     Arena::TOP_WALL+416,    Arena::RIGHT_WALL, Arena::TOP_WALL+416,            (w0+7.9)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE,     Arena::RIGHT_WALL,    Arena::TOP_WALL+416,    Arena::LEFT_WALL,  Arena::TOP_WALL+416,            (w0+7.9)*Timer::LPS);

    const int w1 = 9;
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH,   Arena::TOP_WALL_MID-128,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,  (w1+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH,   Arena::TOP_WALL_MID+128,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,  (w1+0.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_RAY,     Arena::TOP_WALL_MID-256,   Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,        (w1+1.8)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_OCELLUS, Arena::TOP_WALL_MID,       Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID,     Arena::BOTTOM_WALL,        (w1+1.8)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,     Arena::TOP_WALL_MID+256,   Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,        (w1+1.8)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_ANTLION,   Arena::TOP_WALL_MID-128,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,    (w1+3.6)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,   Arena::TOP_WALL_MID+128,   Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,    (w1+3.6)*Timer::LPS);

    const int w2 = 14;
    AddNPC(ShipIndex::HULL_NPC_PARTISAN,   Arena::TOP_WALL_MID,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,  (w2+3.5)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID-172,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-172,   Arena::BOTTOM_WALL,        (w2+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID -64,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID -64,   Arena::BOTTOM_WALL,        (w2+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID-256,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-256,   Arena::BOTTOM_WALL,        (w2+6.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID -64,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID -64,   Arena::BOTTOM_WALL,        (w2+6.5)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID+172,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID+172,   Arena::BOTTOM_WALL,        (w2+8.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID +64,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID +64,   Arena::BOTTOM_WALL,        (w2+8.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID+256,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID+256,   Arena::BOTTOM_WALL,        (w2+8.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID +64,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID +64,   Arena::BOTTOM_WALL,        (w2+8.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CROSS,  Arena::TOP_WALL_MID+128,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID+128,   Arena::BOTTOM_WALL,        (w2+9.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CROSS,  Arena::TOP_WALL_MID+256,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID+256,   Arena::BOTTOM_WALL,        (w2+9.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID-172,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-172,   Arena::BOTTOM_WALL,        (w2+9.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID -64,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID -64,   Arena::BOTTOM_WALL,        (w2+9.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID-256,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-256,   Arena::BOTTOM_WALL,        (w2+9.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS, Arena::TOP_WALL_MID -64,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID -64,   Arena::BOTTOM_WALL,        (w2+9.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CROSS,  Arena::TOP_WALL_MID-128,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-128,   Arena::BOTTOM_WALL,        (w2+10.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CROSS,  Arena::TOP_WALL_MID-256,    Arena::TOP_WALL,     Arena::BOTTOM_WALL_MID-256,   Arena::BOTTOM_WALL,        (w2+10.0)*Timer::LPS);

    const int w3 = 26;
    AddEdgeWarning(Arena::RIGHT_WALL  -64, Arena::TOP_WALL + 416, (w3+0.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_SUNFISH,    Arena::RIGHT_WALL,     Arena::BOTTOM_WALL,   Arena::LEFT_WALL,  Arena::TOP_WALL,            (w3+0.2)*Timer::LPS);
    AddEdgeWarning(Arena::TOP_WALL_MID,    Arena::TOP_WALL +  64, (w3+0.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,   Arena::TOP_WALL_MID,   Arena::TOP_WALL,      Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,    (w3+0.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,   Arena::TOP_WALL_MID,   Arena::TOP_WALL,      Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,    (w3+1.4)*Timer::LPS);
    AddEdgeWarning(Arena::LEFT_WALL   +64, Arena::TOP_WALL +  64,  (w3+1.0)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,   Arena::LEFT_WALL,      Arena::TOP_WALL+64,  Arena::RIGHT_WALL, Arena::TOP_WALL+64,          (w3+1.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,   Arena::LEFT_WALL,      Arena::TOP_WALL+64,  Arena::RIGHT_WALL, Arena::TOP_WALL+64,          (w3+1.9)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_CONSTANT,   Arena::LEFT_WALL,      Arena::TOP_WALL+64,  Arena::RIGHT_WALL, Arena::TOP_WALL+64,          (w3+2.6)*Timer::LPS);
    AddEdgeWarning(Arena::LEFT_WALL   +64, Arena::BOTTOM_WALL - 64,  (w3+3.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_OCELLUS,    Arena::LEFT_WALL,     Arena::BOTTOM_WALL-64,   Arena::RIGHT_WALL,  Arena::BOTTOM_WALL-64, (w3+4.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_OCELLUS,    Arena::LEFT_WALL,     Arena::BOTTOM_WALL-64,   Arena::RIGHT_WALL,  Arena::BOTTOM_WALL-64, (w3+5.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_OCELLUS,    Arena::LEFT_WALL,     Arena::BOTTOM_WALL-64,   Arena::RIGHT_WALL,  Arena::BOTTOM_WALL-64, (w3+6.5)*Timer::LPS);

    const int w4 = 35;
    AddEdgeWarning(Arena::RIGHT_WALL-128, Arena::TOP_WALL+64, (w4+0.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_SPIRIT,  Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL, (w4+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL, (w4+2.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL, (w4+2.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL, (w4+3.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL, (w4+3.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-320, Arena::BOTTOM_WALL, (w4+3.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::RIGHT_WALL-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+320, Arena::BOTTOM_WALL, (w4+3.7)*Timer::LPS);

    AddEdgeWarning(Arena::LEFT_WALL+128, Arena::TOP_WALL+64,  (w4+2.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_SPIRIT,  Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,     (w4+3.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL, (w4+4.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL, (w4+4.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL, (w4+5.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL, (w4+5.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+320, Arena::BOTTOM_WALL, (w4+5.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::LEFT_WALL+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-320, Arena::BOTTOM_WALL, (w4+5.7)*Timer::LPS);

    AddEdgeWarning(Arena::TOP_WALL_MID, Arena::TOP_WALL+64,  (w4+4.5)*Timer::LPS - EDGE_WARNING_EFFECT_LIFESPAN);
    AddNPC(ShipIndex::HULL_NPC_SPIRIT,  Arena::TOP_WALL_MID, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL, (w4+5.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID-64, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+64, Arena::BOTTOM_WALL, (w4+6.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID+64, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-64, Arena::BOTTOM_WALL, (w4+6.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID-128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL, (w4+6.7)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID+128, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL, (w4+6.9)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID-192, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+192, Arena::BOTTOM_WALL, (w4+7.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID+192, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-192, Arena::BOTTOM_WALL, (w4+7.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID-256, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL, (w4+7.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID+256, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL, (w4+7.4)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID-320, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID+320, Arena::BOTTOM_WALL, (w4+7.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_MISSILE, Arena::TOP_WALL_MID+320, Arena::TOP_WALL, Arena::BOTTOM_WALL_MID-320, Arena::BOTTOM_WALL, (w4+7.7)*Timer::LPS);

    const int w5 = 42;
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH,   Arena::TOP_WALL_MID,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,          (w5+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID-256,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,  (w5+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID+256,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,  (w5+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,     Arena::TOP_WALL_MID-320,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,  (w5+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,     Arena::TOP_WALL_MID+320,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,  (w5+2.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_OCELLUS,      Arena::TOP_WALL_MID,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,         (w5+5.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID-256,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,  (w5+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID+256,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,  (w5+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,     Arena::TOP_WALL_MID-320,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,  (w5+7.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANTLION,     Arena::TOP_WALL_MID+320,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,  (w5+7.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL,          (w5+10.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH,   Arena::TOP_WALL_MID-256,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-128, Arena::BOTTOM_WALL,  (w5+11.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_ANGELFISH,   Arena::TOP_WALL_MID+256,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+128, Arena::BOTTOM_WALL,  (w5+11.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID-320,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,  (w5+12.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_RAY,         Arena::TOP_WALL_MID+320,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,  (w5+12.0)*Timer::LPS);

    const int w6 = 57;
    AddNPC(ShipIndex::HULL_NPC_PARTISAN,    Arena::TOP_WALL_MID+128,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,  (w6+0.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_SUNFISH,     Arena::TOP_WALL_MID-128,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID-256, Arena::BOTTOM_WALL,  (w6+1.5)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_PARTISAN,    Arena::TOP_WALL_MID+128,   Arena::TOP_WALL,   Arena::BOTTOM_WALL_MID+256, Arena::BOTTOM_WALL,  (w6+3.0)*Timer::LPS);
}

void Stage::InitSection3()
{
    Audio::SetActiveBgm(Audio::s3Bgm, 11.5);
    sectionLength = 300*Timer::LPS;
    const int debugSkipTo = 0.0*Timer::LPS;
    sectionProgress = debugSkipTo;

    const int w0 = 0;
    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID,                Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,           Arena::BOTTOM_WALL,        (w0+1.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID - 256,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID - 256,     Arena::BOTTOM_WALL,        (w0+5.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID - 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID - 128,     Arena::BOTTOM_WALL,        (w0+9.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID + 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID + 128,     Arena::BOTTOM_WALL,        (w0+2.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID + 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID + 128,     Arena::BOTTOM_WALL,        (w0+3.0)*Timer::LPS);

    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID - 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID - 128,     Arena::BOTTOM_WALL,        (w0+6.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID - 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID - 128,     Arena::BOTTOM_WALL,        (w0+8.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID + 256,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID + 256,     Arena::BOTTOM_WALL,        (w0+12.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID,                Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID,           Arena::BOTTOM_WALL,        (w0+16.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_AEGIS,     Arena::TOP_WALL_MID + 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID + 128,     Arena::BOTTOM_WALL,        (w0+20.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID + 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID + 128,     Arena::BOTTOM_WALL,        (w0+13.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID + 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID + 128,     Arena::BOTTOM_WALL,        (w0+14.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID - 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID - 128,     Arena::BOTTOM_WALL,        (w0+17.0)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_DISCUS,    Arena::TOP_WALL_MID - 128,          Arena::TOP_WALL,           Arena::BOTTOM_WALL_MID - 128,     Arena::BOTTOM_WALL,        (w0+18.0)*Timer::LPS);

    const int w1 = 30;
    AddStageEvent(STAGE_EVENT_ANTIGEN_WARNING, (w1+0.2)*Timer::LPS);
    AddNPC(ShipIndex::HULL_NPC_SCHEHERAZADE, Arena::BOTTOM_WALL_MID, Arena::BOTTOM_WALL, Arena::TOP_WALL_MID, Arena::TOP_WALL-256, (w1+2.2)*Timer::LPS);

    AddStageEvent(STAGE_EVENT_SCHEHERAZADE_BATTLE_MODE, (w1+4.0)*Timer::LPS);
}
