#include "ship.h"

Ship::Ship()
{

}

Ship::~Ship()
{
    persistentBulletHits.clear();

    for(std::vector<Emitter*>::iterator it = emitters.begin(); it != emitters.end();)
    {
        delete *it;
        *it = nullptr;
        it = emitters.erase(it);
    }
}

void Ship::Initialize()
{
    Actor::Initialize();

    isAutopilot = false;

    SetHasDestination(false);
    //SetXYDestination(0,0);

    SetOnDamageGrace(false);
    SetOnDamageGraceInputBlock(false);
    SetDamageXYBounceVelocity(0, 0);

    SetCoreOverloadFrame(0);
    SetCoreOverloadFrameTick(0);

    inDeathSequence = false;
    deathSequenceTicks = 0;
    deathSequenceTicksMax = 0;

    SetMaxHP(1);
    SetMoveSpeed(4);
    SetTrackedTarget(nullptr);
    SetHitboxXYOffset(24,24);
    SetHitboxDimensions(32,32);

    emitterXOffset = 0;
    emitterYOffset = 0;

    canMakeAfterimages = false;
    isAfterimagesEnabled = false;
    afterimageFormUsed = ParticleIndex::PARTICLE_PC_CORE_AFTERIMAGE;
    afterimageTicks = 0;
    afterimageTicksRequired = AFTERIMAGE_DEFAULT_TICKS_REQUIRED;
    //isAfterimageBoostMode = false;
}

void Ship::Logic()
{
    Actor::Logic();

    if(onDamageGrace)
    {
        damageGraceTicksRemaining --;
        if(damageGraceTicksRemaining <= 0)
            onDamageGrace = false;

        if(onDamageGraceInputBlock)
        {
            damageGraceInputBlockTick ++;
            if(damageGraceInputBlockTick > DAMAGE_GRACE_MAX_INPUT_BLOCK_TICKS)
            {
                onDamageGraceInputBlock = false;
                damageXBounceVelocity = 0.0;
                damageYBounceVelocity = 0.0;
            }
        }

    }

    if(inDeathSequence)
    {
        deathSequenceTicks++;

        //if(deathSequenceTicks > deathSequenceTicksMax)
        //SetIsAlive(false); // Let's not. Objects of Ship's derived classes should handle this one on their own.
    }

    if(onDamageGrace || inDeathSequence)
    {
        ProgressDamageBounce();

        coreOverloadFrameTick ++;
        if(coreOverloadFrameTick >= ShipIndex::NUM_CORE_OVERLOAD_FRAME_TICKS)
        {
            coreOverloadFrameTick = 0;
            coreOverloadFrame ++;

            if(coreOverloadFrame >= ShipIndex::NUM_CORE_OVERLOAD_FRAMES)
                coreOverloadFrame = 0;
        }
    }

    for(std::vector<Emitter*>::iterator it = emitters.begin(); it != emitters.end(); ++it)
    {
        (*it)->SetXYPosition(GetXPosition() + emitterXOffset, GetYPosition() + emitterYOffset);

        // Emitter tracks the same target as the ship it belongs to.
        if(GetHasTrackedTarget())
        {
            if((*it)->GetTrackedTarget() != Ship::GetTrackedTarget())
            {
                (*it)->SetTrackedTarget(Ship::GetTrackedTarget());
            }
        }

        (*it)->Logic();
    }
}

void Ship::EnableAutopilot(float dest_x, float dest_y, float auto_speed, float fixed_sprite_rotation)
{
    isAutopilot = true;
    SetXYDestination(dest_x, dest_y);
    SetMoveSpeed(auto_speed);
    autopilotFixedSpriteRotation = fixed_sprite_rotation;
}

void Ship::DisableAutopilot()
{
    SetMoveAngle(autopilotFixedSpriteRotation); // Prevents one frame of un-updated move angle for PC. Remains to be seen if this will cause a bug if autopilot system is implemented for all npcs.
    isAutopilot = false;
    SetIsAtDestination(true);
    SetMoveSpeed(ShipIndex::PC_STANDARD_MOVESPEED);
}

void Ship::ProgressDamageBounce()
{
    SetXYPosition(GetXPosition() + damageXBounceVelocity, GetYPosition() + damageYBounceVelocity);

    if(std::abs(damageXBounceVelocity) <= DAMAGE_MOVE_STABILIZATION)
        damageXBounceVelocity = 0;
    if(damageXBounceVelocity > 0)
        damageXBounceVelocity -= DAMAGE_MOVE_STABILIZATION;
    else if(damageXBounceVelocity < 0)
        damageXBounceVelocity += DAMAGE_MOVE_STABILIZATION;

    if(std::abs(damageYBounceVelocity) <= DAMAGE_MOVE_STABILIZATION)
        damageYBounceVelocity = 0;
    if(damageYBounceVelocity > 0)
        damageYBounceVelocity -= DAMAGE_MOVE_STABILIZATION;
    else if(damageYBounceVelocity < 0)
        damageYBounceVelocity += DAMAGE_MOVE_STABILIZATION;
}

void Ship::InitDamageGrace(int duration)
{
    onDamageGrace = true;
    onDamageGraceInputBlock = true;
    damageGraceTicksRemaining = duration;
    damageGraceInputBlockTick = 0;
}

void Ship::InitDamageBounce(float bullet_x, float bullet_y, float velocity)
{
    float hitAngle = std::atan2(bullet_y - GetYPosition(), bullet_x - GetXPosition());
    damageXBounceVelocity = velocity * std::cos(hitAngle) * -1;
    damageYBounceVelocity = velocity * std::sin(hitAngle) * -1;

    //damageBounceRotationOffset += hitAngle;
}

void Ship::InitDeathSequence(int sequence_ticks)
{
    //float randomAngle = Hax::RandFloat(2*ALLEGRO_PI);

    inDeathSequence = true;
    deathSequenceTicks = 0;
    deathSequenceTicksMax = sequence_ticks;
    SetMoveSpeed(0);

    for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end(); ++it)
    {
        (*it)->SetIsOnline(false);
    }
}


void Ship::AfterimageUpdate(bool is_flipped_horizontal)
{
    if(isAfterimagesEnabled)
    {
        afterimageTicks ++;
        if(afterimageTicks >= afterimageTicksRequired)
        {
            afterimageTicks = 0;

            //if(!onDamageGraceInputBlock) // Not implemented for subships.
            //{
                Particle *afterimage = new Particle();

                afterimage->Initialize(afterimageFormUsed, 0.0, GetPreviousSpriteRotation(), AFTERIMAGE_LIFESPAN);
                afterimage->SetAllXYPositions(GetPreviousXPosition(), GetPreviousYPosition());

                if(is_flipped_horizontal)
                    afterimage->SetIsFlippedHorizontal(true);

                Particle::afterimages.push_back(afterimage);
            //}
        }
    }
}
