#include "score.h"

int Score::score;

int Score::pcHitsReceived;

int Score::multiplierExponent;
int Score::multiplierValue;
bool Score::isMultiplierOverflowSignal;

int Score::comboCounterNumFill;

int Score::npcsDestroyed;
int Score::npcDestructionChain;
int Score::recordNpcDestructionChain;

int Score::npcDestructionIdleLockedTicks;
int Score::npcDestructionIdle;

bool Score::powerupDropAvailable;
int Score::ticksToPowerupDrop;

void Score::Initialize()
{
    score = 0;

    pcHitsReceived = 0;

    multiplierExponent = 0;
    multiplierValue = 1;
    isMultiplierOverflowSignal = false;

    npcsDestroyed = 0;

    npcDestructionChain = 0;
    recordNpcDestructionChain = 0;

    npcDestructionIdleLockedTicks = 0;
    npcDestructionIdle = 0;

    UpdateMultiplier();

    powerupDropAvailable = false;
    ticksToPowerupDrop = 0;
}


void Score::Logic()
{
    if(npcDestructionChain > 0)
    {
            npcDestructionIdle ++;
            if(npcDestructionIdleLockedTicks > 0)
            {
                npcDestructionIdle = 0;
                npcDestructionIdleLockedTicks --;
            }

            if(npcDestructionIdle >= NPC_DESTRUCTION_RESET_TIME)
            {
                npcDestructionChain = 0;
                multiplierExponent = 0;
                UpdateMultiplier();
            }
    }

    if(! powerupDropAvailable)
    {
        ticksToPowerupDrop ++;
        if(ticksToPowerupDrop >= REQ_TICKS_TO_POWERUP_DROP)
        {
            powerupDropAvailable = true;
            //std::cout << "powerup drop now available" << std::endl;
        }
    }
}

void Score::AddNPCDestructionValue(int score_value)
{
    npcDestructionIdle = 0;
    npcDestructionChain ++;
    if(recordNpcDestructionChain < npcDestructionChain)
        recordNpcDestructionChain = npcDestructionChain;

    comboCounterNumFill ++;
    if(comboCounterNumFill >= NPC_DESTRUCTIONS_PER_MULTIPLIER_EXPONENT_INCREASE)
    {
        comboCounterNumFill = 0;
        multiplierExponent ++;
        Audio::AddSfx(Audio::multiplierAdvance0);

        if(multiplierExponent > MAX_MULTIPLIER_EXPONENT)
            multiplierExponent = MAX_MULTIPLIER_EXPONENT;

        isMultiplierOverflowSignal = true;
    }

    UpdateMultiplier();

    int scoreIncrease = score_value * multiplierValue;
    score += scoreIncrease;
}

void Score::UpdateMultiplier()
{
    multiplierValue = std::pow(MULTIPLIER_BASE, multiplierExponent);
}

void Score::PCHitPenalty()
{
    Score::pcHitsReceived ++;

    npcDestructionChain = 0;
    comboCounterNumFill = 0;
    multiplierValue = 1;
    multiplierExponent = 0;

    Audio::AddSfx(Audio::pcHit0);

}
