#include "powerupdrop.h"

std::vector<PowerupDrop*> PowerupDrop::powerupDrops;

PowerupDrop::PowerupDrop()
{

}

PowerupDrop::~PowerupDrop()
{
    //std::cout << "powerup drop: destruction test" << std::endl;
}

void PowerupDrop::Initialize(float x, float y)
{
    Actor::Initialize();

    SetAllXYPositions(x, y);
    SetSpriteDimensions(128,128);
    SetHitboxXYOffset(GetSpriteWidth()/ -2, GetSpriteHeight()/ -2);
    SetHitboxDimensions(GetSpriteWidth(), GetSpriteHeight());

    remainingLifespan = INITIAL_LIFESPAN;

    //SetMoveSpeed(0);
    dropVelocity = INITIAL_DROP_VELOCITY;
    reachedPreDropAccelerationMinimumYPosition = false;

    SetAllSpriteRotations(2*ALLEGRO_PI * -0.25);

    effect = rand()%PowerupDropIndex::NUM_EFFECTS;

    effectCyclingTicks = 0;
}

void PowerupDrop::Logic()
{
    SetYPosition(GetYPosition() + dropVelocity);
    if(GetYPosition() < PRE_DROP_ACCELERATION_MINIMUM_Y_POSITION )
        reachedPreDropAccelerationMinimumYPosition = true;

    if(dropVelocity != MAX_DROP_VELOCITY && reachedPreDropAccelerationMinimumYPosition)
    {
        dropVelocity += DROP_ACCELERATION;
        if(dropVelocity > MAX_DROP_VELOCITY)
            dropVelocity = MAX_DROP_VELOCITY;
    }

    if(GetXPosition() - GetSpriteWidth()/2 < Arena::LEFT_WALL)
        SetXPosition(Arena::LEFT_WALL + GetSpriteWidth()/2);
    else if (GetXPosition() + GetSpriteWidth()/2 > Arena::RIGHT_WALL)
        SetXPosition(Arena::RIGHT_WALL - GetSpriteWidth()/2);

    ///UpdateInterpolation();

    effectCyclingTicks ++;
    if(effectCyclingTicks > EFFECT_CYCLING_TICKS_MAX)
    {
        effectCyclingTicks = 0;
        effect++;
        if(effect >= PowerupDropIndex::NUM_EFFECTS)
            effect = 0;
    }

    remainingLifespan --;
    if(remainingLifespan <= 0)
        SetIsActive(false);


}

void PowerupDrop::Drawing()
{
    UpdateInterpolation();

    al_draw_rotated_bitmap(Image::powerupDropSub[effect], GetSpriteWidth()/2, GetSpriteHeight()/2,
                            GetInterpolatedXPosition(), GetInterpolatedYPosition(),
                            GetInterpolatedSpriteRotation(), 0);

}
