#include "pc.h"

PC* PC::pc;

PC::PC()
{

}

PC::~PC()
{
    for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end();)
    {
        delete (*it);
        it = subships.erase(it);
    }
}

void PC::Initialize(int whichHullType)
{
    Ship::Initialize();
    Ship::SetHullType(whichHullType);

    SetAllXYPositions(320, -128);

    SetHitboxXYOffset(-16, -16);
    SetHitboxDimensions(32, 32);

    SetMoveAngle(0.75 * 2*ALLEGRO_PI);
    SetMoveSpeed(ShipIndex::PC_STANDARD_MOVESPEED);

    EnableAutopilot(320, 400, ShipIndex::PC_AUTOPILOT_MOVESPEED, 2*ALLEGRO_PI * -0.25);
    //SetIsAfterimageBoostMode(true);

    lives = 3;
    steeringAngleOffset = 0.0;
    steeringAngleOffsetDestination = 0.0;

    Emitter*mainEmitter = new Emitter();
    Emitter*verticalSlashEmitter = new Emitter();
    Emitter*horizontalSlashEmitterLeft = new Emitter();
    Emitter*horizontalSlashEmitterRight = new Emitter();

    ChangeSubshipFormation(FORMATION_NEUTRAL);

    switch(Ship::GetHullType())
    {
    case HULL_PC_ORTHOS_A:
        mainEmitter->Initialize(EmitterIndex::EMITTER_PRESET_PC_MAIN);
        verticalSlashEmitter->Initialize(EmitterIndex::EMITTER_PRESET_PC_FORWARD_SLASH); // Default: FORWARD_SLASH
        horizontalSlashEmitterLeft->Initialize(EmitterIndex::EMITTER_PRESET_PC_SIDE_SLASH); // Default:: SIDE_SLASH
        horizontalSlashEmitterRight->Initialize(EmitterIndex::EMITTER_PRESET_PC_SIDE_SLASH);

        //AddSubship(ShipIndex::SUBSHIP_HULL_DORU, false); // left hand
        //AddSubship(ShipIndex::SUBSHIP_HULL_DORU, true);  // left hand
        AddSubship(ShipIndex::SUBSHIP_HULL_XIPHOS, false); // left hand
        AddSubship(ShipIndex::SUBSHIP_HULL_XIPHOS, true);  // right hand

        break;
    }

    AddEmitter(mainEmitter);
    AddEmitter(verticalSlashEmitter);
    AddEmitter(horizontalSlashEmitterLeft);
    AddEmitter(horizontalSlashEmitterRight);

    for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end(); ++it)
    {
        (*it)->SetHasTrackedPosition(true);
        (*it)->SetIsSpawnFiringDelay(false);
    }

    SetEmitterXYOffset(0, -64);

    SetNumFrames(ShipIndex::PC_CORE_NUM_FRAMES);

    EnableAfterimages(ParticleIndex::PARTICLE_PC_CORE_AFTERIMAGE);

    //EnablePowerup(PowerupDropIndex::SPREAD_CANNON);
    //EnablePowerup(PowerupDropIndex::HYPER_CANNON);
    //EnablePowerup(PowerupDropIndex::UPGRADED_SLASH);
    //EnablePowerup(PowerupDropIndex::OVERSHIELD);
    //EnablePowerup(PowerupDropIndex::DORU_SUPPORT);
    //DisablePowerup(PowerupDropIndex::DORU_SUPPORT);
    overshieldFrame = 0;
    overshieldFrameDelayTicks = 0;
    overshieldSpriteRotation = 0.0;
    trackedPowerup = PowerupDropIndex::SPREAD_CANNON;
}

void PC::Logic()
{
    Ship::Logic();

/// Movement and bounds checking begin

    if(!GetIsAutopilot())
    {
        if(! GetOnDamageGraceInputBlock())
        {
            if(moveInputReceived[Direction::UP])
                SetYPosition(GetYPosition()-GetMoveSpeed());
            if(moveInputReceived[Direction::DOWN])
                SetYPosition(GetYPosition()+GetMoveSpeed());
            if(moveInputReceived[Direction::LEFT])
            {
                SetXPosition(GetXPosition()-GetMoveSpeed());
                steeringAngleOffsetDestination -= STEERING_ANGLE_CORRECTION;

                if(steeringAngleOffsetDestination < MAX_STEERING_ANGLE * -1)
                    steeringAngleOffsetDestination = MAX_STEERING_ANGLE * -1;
            }
            if(moveInputReceived[Direction::RIGHT])
            {
                SetXPosition(GetXPosition()+GetMoveSpeed());
                steeringAngleOffsetDestination += STEERING_ANGLE_CORRECTION;

                if(steeringAngleOffsetDestination > MAX_STEERING_ANGLE)
                    steeringAngleOffsetDestination = MAX_STEERING_ANGLE;
            }
        }

        for(size_t i = 0; i < Direction::NUM_DIRECTIONS; i++)
            moveInputReceived[i] = false;

        if(GetXPosition() < 0 + GetSpriteWidth()/2)
            SetXPosition(0 + GetSpriteWidth()/2);
        else if(GetXPosition() > Arena::WIDTH - GetSpriteWidth()/2)
            SetXPosition(Arena::WIDTH - GetSpriteWidth()/2);
        if(GetYPosition() < 0 + GetSpriteHeight()/2)
            SetYPosition(0 + GetSpriteHeight()/2);
        else if(GetYPosition() > Arena::HEIGHT - GetSpriteHeight()/2)
            SetYPosition(Arena::HEIGHT - GetSpriteHeight()/2);

        if(steeringAngleOffset < steeringAngleOffsetDestination - STEERING_ANGLE_NORMALIZATION)
            steeringAngleOffset += STEERING_ANGLE_CORRECTION;
        else if(steeringAngleOffset > steeringAngleOffsetDestination + STEERING_ANGLE_NORMALIZATION)
            steeringAngleOffset -= STEERING_ANGLE_CORRECTION;

        if(steeringAngleOffsetDestination != 0.0)
        {
            if(steeringAngleOffsetDestination < 0.0)
                steeringAngleOffsetDestination += STEERING_ANGLE_NORMALIZATION;
            else if(steeringAngleOffsetDestination > 0.0)
                steeringAngleOffsetDestination -= STEERING_ANGLE_NORMALIZATION;

            if(std::abs(steeringAngleOffsetDestination) <= STEERING_ANGLE_NORMALIZATION)
                steeringAngleOffsetDestination = 0.0;
        }

        SetMoveAngle(0.75 * 2*ALLEGRO_PI + steeringAngleOffsetDestination);
    }
    else // GetIsAutopilot()
    {
        float opposite = GetYDestination() - GetYPosition();
        float adjacent = GetXDestination() - GetXPosition();
        SetMoveAngle( std::atan2(opposite, adjacent) );
        SetXPosition( GetXPosition() + std::cos(GetMoveAngle())*GetMoveSpeed());
        SetYPosition( GetYPosition() + std::sin(GetMoveAngle())*GetMoveSpeed());


        if(std::abs(GetXDestination() - GetXPosition()) <= GetMoveSpeed()
                && std::abs(GetYDestination() - GetYPosition()) <= GetMoveSpeed())
        {
            //std::cout << "Destination reached, autopilot disabling..." << std::endl;
            DisableAutopilot();
            //SetIsAfterimageBoostMode(false);
        }
    }

/// Movement and bounds checking end
/// Subship formation begin

    if(subshipFormation == FORMATION_NEUTRAL && !GetIsAutopilot())
    {
        if(fireInputReceived[1] && ! GetOnDamageGraceInputBlock())
        {
            ChangeSubshipFormation(FORMATION_XIPHOS_VERTICAL_CROSS);
        }
        else if(fireInputReceived[2] && !GetOnDamageGraceInputBlock())
        {
            ChangeSubshipFormation(FORMATION_XIPHOS_HORIZONTAL_CROSS);
        }
    }
    else
    {
        subshipFormationCurrentFrame ++;
        if(subshipFormationCurrentFrame > subshipFormationMaxFrame.at(subshipFormation))
            ChangeSubshipFormation(subshipFormationNext);

    }
/// Subship formation end
/// Powerup status update begin
    for(size_t i = 0; i < PowerupDropIndex::NUM_EFFECTS; i++)
    {
        if(isPowerupActive[i] )
        {
            powerupNumCharges[i]--;
            if(powerupNumCharges[i] <= 0)
                DisablePowerup(i);
        }
    }

    if(isPowerupActive[PowerupDropIndex::OVERSHIELD])
    {
        overshieldFrameDelayTicks ++;
        if(overshieldFrameDelayTicks > OVERSHIELD_FRAME_DELAY_MAX)
        {
            overshieldFrameDelayTicks = 0;
            overshieldFrame++;
            if(overshieldFrame >= PowerupDropIndex::OVERSHIELD_NUM_FRAMES)
                overshieldFrame = 0;
        }

        overshieldSpriteRotation += 0.01;
        if(overshieldSpriteRotation > ALLEGRO_PI*2)
            overshieldSpriteRotation -= ALLEGRO_PI*2;
    }

/// Powerup status update end
/// Afterimage update begin
    //if(!GetOnDamageGraceInputBlock())
        AfterimageUpdate(false);
/// Afterimage update end

/// Main emitter firing begin
    if(subshipFormation == FORMATION_NEUTRAL && !GetIsAutopilot() && ! GetOnDamageGraceInputBlock())
    {
        GetEmitter(0)->SetIsOnline(fireInputReceived[0]); // Fire main cannon
        GetEmitter(0)->SetTrackedXYPosition(GetXPosition(), GetYPosition() - 256);
    }
    else
        GetEmitter(0)->SetIsOnline(false);

    if(subshipFormation == FORMATION_XIPHOS_VERTICAL_SLASH && !GetIsAutopilot() && !GetOnDamageGraceInputBlock()) // Reminder that "cross" animation does not fire beams; the followup "slash" does.
    {
        GetEmitter(1)->SetIsOnline(true);
        GetEmitter(1)->SetTrackedXYPosition(GetXPosition(), GetYPosition() - 256);
    }
    else
        GetEmitter(1)->SetIsOnline(false);

    if(subshipFormation == FORMATION_XIPHOS_HORIZONTAL_SLASH && !GetIsAutopilot() && !GetOnDamageGraceInputBlock())
    {
        GetEmitter(2)->SetIsOnline(true);
        GetEmitter(2)->SetTrackedXYPosition(GetXPosition()-256, GetYPosition());

        GetEmitter(3)->SetIsOnline(true);
        GetEmitter(3)->SetTrackedXYPosition(GetXPosition()+256, GetYPosition());
    }
    else
    {
        GetEmitter(2)->SetIsOnline(false);
        GetEmitter(3)->SetIsOnline(false);
    }


/// Main emitter firing end
/// Subship update begin

    for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
    {
        if(!GetIsAutopilot())
        {
            for(std::vector<Emitter*>::iterator jt = (*it)->GetEmitterVector().begin(); jt != (*it)->GetEmitterVector().end(); ++jt)
            {
                (*jt)->SetIsOnline(fireInputReceived[0]);
            }
        }

        (*it)->Logic();
    }
/// Subship update end

/// Bullet collision begin

    if(isPowerupActive[PowerupDropIndex::OVERSHIELD])
    {
        for(std::vector<Bullet*>::iterator it = Bullet::bullets.begin(); it != Bullet::bullets.end(); ++it)
        {
            if(Hax::AABBCollision(GetXPosition() + OVERSHIELD_HITBOX_X_OFFSET, GetYPosition() + OVERSHIELD_HITBOX_Y_OFFSET, OVERSHIELD_HITBOX_WIDTH, OVERSHIELD_HITBOX_HEIGHT,
                                  (*it)->GetXPosition() + (*it)->GetHitboxXOffset(), (*it)->GetYPosition() + (*it)->GetHitboxYOffset(), (*it)->GetHitboxWidth(), (*it)->GetHitboxHeight()))
            {
                if((*it)->GetIsNPCBullet())
                {
                    (*it)->EmitHitSparks(ParticleIndex::PARTICLE_HIT_BLACK, 6);
                    (*it)->SetIsActive(false);
                }
            }
        }
    }

    for(std::vector<Bullet*>::iterator it = Bullet::bullets.begin(); it != Bullet::bullets.end(); ++it)
    {
        if((*it)->GetIsNPCBullet())
        {
            if(Hax::AABBCollision(GetXPosition() + GetHitboxXOffset(), GetYPosition() + GetHitboxYOffset(), GetHitboxWidth(), GetHitboxHeight(),
                                  (*it)->GetXPosition() + (*it)->GetHitboxXOffset(), (*it)->GetYPosition() + (*it)->GetHitboxYOffset(), (*it)->GetHitboxWidth(), (*it)->GetHitboxHeight()))
            {
                if( (*it)->GetIsPersistent())
                {
                    if( std::count(GetPersistentBulletHitsVector().begin(), GetPersistentBulletHitsVector().end(), *it) == 0)
                    {
                        AddPersistentBulletHits(*it);

                        if(!GetOnDamageGrace() && !isPowerupActive[PowerupDropIndex::OVERSHIELD])
                        {
                            (*it)->EmitHitSparks(ParticleIndex::PARTICLE_HIT_BLACK, 6);
                            Score::PCHitPenalty();
                            InitDamageGrace(ShipIndex::TRUE_DAMAGE_GRACE_TICKS_MAX);
                            InitDamageBounce((*it)->GetXPosition(), (*it)->GetYPosition(), ShipIndex::PC_DAMAGE_BOUNCE_VELOCITY);
                        }
                    }
                }
                else
                {
                    (*it)->SetIsActive(false);

                    if(!GetOnDamageGrace() && !isPowerupActive[PowerupDropIndex::OVERSHIELD])
                    {
                        (*it)->EmitHitSparks(ParticleIndex::PARTICLE_HIT_BLUE, 6);
                        Score::PCHitPenalty();
                        InitDamageGrace(ShipIndex::TRUE_DAMAGE_GRACE_TICKS_MAX);
                        InitDamageBounce((*it)->GetXPosition(), (*it)->GetYPosition(), ShipIndex::PC_DAMAGE_BOUNCE_VELOCITY);
                    }
                }
            }
        }
    }
/// Bullet collision end
/// Powerup drop collision begin

    for(std::vector<PowerupDrop*>::iterator it = PowerupDrop::powerupDrops.begin(); it != PowerupDrop::powerupDrops.end(); ++it)
    {
        if(Hax::AABBCollision(GetXPosition() + GetHitboxXOffset(), GetYPosition() + GetHitboxYOffset(), GetHitboxWidth(), GetHitboxHeight(),
                              (*it)->GetXPosition() + (*it)->GetHitboxXOffset(), (*it)->GetYPosition() + (*it)->GetHitboxYOffset(), (*it)->GetHitboxWidth(), (*it)->GetHitboxHeight()))
        {
            (*it)->SetIsActive(false);
            EnablePowerup((*it)->GetEffect());

            Audio::AddSfx(Audio::pickup0);
        }
    }

/// Powerup drop collision end
/// Input reset begin
    for(size_t i = 0; i < NUM_FIRE_BUTTONS; i++)
        fireInputReceived[i] = false;
/// Input reset end

/// Sprite update begin
    if(!GetIsAutopilot())
        SetSpriteRotation(GetMoveAngle());
    else
        SetSpriteRotation(GetAutopilotFixedSpriteRotation());

    ///UpdateInterpolation();

/// Sprite update end
}

void PC::AddSubship(int hull_preset, bool is_right_handed)
{
    Subship *sub = new Subship();
    sub->Initialize(hull_preset, this, is_right_handed);

    subships.push_back(sub);
}

void PC::ChangeSubshipFormation(int formation)
{
    subshipFormation = formation;
    subshipFormationCurrentFrame = 0;

    switch(subshipFormation)
    {
    case FORMATION_NEUTRAL:
        subshipFormationNext = FORMATION_NEUTRAL;
        for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
            (*it)->SetAttachmentType( ShipIndex::subshipNeutralAttachmentType.at( (*it)->GetHullType() ) );


        //std::cout << "Form Neutral" << std::endl;
        //std::cout << std::endl;
        break;

    case FORMATION_XIPHOS_VERTICAL_CROSS:
        subshipFormationNext = FORMATION_XIPHOS_VERTICAL_SLASH;
        for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
        {
            if((*it)->GetHullType() == ShipIndex::SUBSHIP_HULL_XIPHOS)
                (*it)->SetAttachmentType(ShipIndex::ATTACH_XIPHOS_VERTICAL_CROSS);
        }
        //std::cout << "Form V cross" << std::endl;
        break;

    case FORMATION_XIPHOS_VERTICAL_SLASH:
        subshipFormationNext = FORMATION_NEUTRAL;
        for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
        {
            if((*it)->GetHullType() == ShipIndex::SUBSHIP_HULL_XIPHOS)
                (*it)->SetAttachmentType(ShipIndex::ATTACH_XIPHOS_VERTICAL_SLASH);
        }
        //std::cout << "Form V slash " << std::endl;
        break;

    case FORMATION_XIPHOS_HORIZONTAL_CROSS:
        subshipFormationNext = FORMATION_XIPHOS_HORIZONTAL_SLASH;
        for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
        {
            if((*it)->GetHullType() == ShipIndex::SUBSHIP_HULL_XIPHOS)
                (*it)->SetAttachmentType(ShipIndex::ATTACH_XIPHOS_HORIZONTAL_CROSS);
        }
        //std::cout << "Form H cross " << std::endl;
        break;

    case FORMATION_XIPHOS_HORIZONTAL_SLASH:
        subshipFormationNext = FORMATION_NEUTRAL;
        for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
        {
            if((*it)->GetHullType() == ShipIndex::SUBSHIP_HULL_XIPHOS)
                (*it)->SetAttachmentType(ShipIndex::ATTACH_XIPHOS_HORIZONTAL_SLASH);
        }
        //std::cout << "Form H slash " << std::endl;
        break;
    }

}

void PC::EnablePowerup(size_t index)
{
    //std::cout << "Powerup " << PowerupDropIndex::powerupNames.at(index) << " enabled." << std::endl;

    isPowerupActive[index] = true;
    powerupNumCharges[index] = PowerupDropIndex::numCharges.at(index);

    trackedPowerup = index;

    FlyingText* powerupNameText = new FlyingText();
    powerupNameText->Initialize(PowerupDropIndex::powerupNames.at(index), FONTDEF_FLYINGTEXT_POWERUP_NAME, GetXPosition(), GetYPosition());
    FlyingText::flyingTexts.push_back(powerupNameText);

    switch(index)
    {
    case PowerupDropIndex::SPREAD_CANNON:
        GetEmitter(0)->Initialize(EmitterIndex::EMITTER_PRESET_PC_SPREAD_CANNON);
        GetEmitter(0)->SetHasTrackedPosition(true);
        GetEmitter(0)->SetIsSpawnFiringDelay(false);
        break;
    case PowerupDropIndex::UPGRADED_SLASH:
        GetEmitter(1)->Initialize(EmitterIndex::EMITTER_PRESET_PC_UPGRADED_FORWARD_SLASH);
        GetEmitter(1)->SetHasTrackedPosition(true);
        GetEmitter(1)->SetIsSpawnFiringDelay(false);

        GetEmitter(2)->Initialize(EmitterIndex::EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH);
        GetEmitter(2)->SetHasTrackedPosition(true);
        GetEmitter(2)->SetIsSpawnFiringDelay(false);

        GetEmitter(3)->Initialize(EmitterIndex::EMITTER_PRESET_PC_UPGRADED_SIDE_SLASH);
        GetEmitter(3)->SetHasTrackedPosition(true);
        GetEmitter(3)->SetIsSpawnFiringDelay(false);
        break;
    case PowerupDropIndex::OVERSHIELD:
        overshieldFrame = 0;
        overshieldFrameDelayTicks = 0;
        break;
    case PowerupDropIndex::DORU_SUPPORT:
        AddSubship(ShipIndex::SUBSHIP_HULL_DORU, false); // left hand
        AddSubship(ShipIndex::SUBSHIP_HULL_DORU, true);  // left hand
        break;
    case PowerupDropIndex::HYPER_CANNON:
        GetEmitter(0)->Initialize(EmitterIndex::EMITTER_PRESET_PC_HYPER_CANNON);
        GetEmitter(0)->SetHasTrackedPosition(true);
        GetEmitter(0)->SetIsSpawnFiringDelay(false);
        break;

    }
}

void PC::DisablePowerup(size_t index)
{
    //std::cout << "Powerup " << PowerupDropIndex::powerupNames.at(index) << " disabled." << std::endl;

    isPowerupActive[index] = false;
    powerupNumCharges[index] = 0; // In case it wasn't already.

    switch(index)
    {
    case PowerupDropIndex::SPREAD_CANNON:
        GetEmitter(0)->Initialize(EmitterIndex::EMITTER_PRESET_PC_MAIN); // reset to default
        GetEmitter(0)->SetHasTrackedPosition(true);
        GetEmitter(0)->SetIsSpawnFiringDelay(false);
        break;
    case PowerupDropIndex::UPGRADED_SLASH:
        GetEmitter(1)->Initialize(EmitterIndex::EMITTER_PRESET_PC_FORWARD_SLASH);
        GetEmitter(1)->SetHasTrackedPosition(true);
        GetEmitter(1)->SetIsSpawnFiringDelay(false);

        GetEmitter(2)->Initialize(EmitterIndex::EMITTER_PRESET_PC_SIDE_SLASH);
        GetEmitter(2)->SetHasTrackedPosition(true);
        GetEmitter(2)->SetIsSpawnFiringDelay(false);

        GetEmitter(3)->Initialize(EmitterIndex::EMITTER_PRESET_PC_SIDE_SLASH);
        GetEmitter(3)->SetHasTrackedPosition(true);
        GetEmitter(3)->SetIsSpawnFiringDelay(false);
        break;
    case PowerupDropIndex::OVERSHIELD:
        break;
    case PowerupDropIndex::DORU_SUPPORT:
        for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end();)
        {
            if((*it)->GetHullType() == ShipIndex::SUBSHIP_HULL_DORU)
            {
                delete (*it);
                it = subships.erase(it);
            }
            else
                ++it;
        }

        break;
    case PowerupDropIndex::HYPER_CANNON:
        GetEmitter(0)->Initialize(EmitterIndex::EMITTER_PRESET_PC_MAIN);
        GetEmitter(0)->SetHasTrackedPosition(true);
        GetEmitter(0)->SetIsSpawnFiringDelay(false);
        break;

    }
}


void PC::MainDrawing()
{
    // Don't UpdateInterpolation() here, do it in overworld. Reason: There are many different PC drawing functions.

    al_draw_rotated_bitmap(Image::pcCoreSub[GetCurrentFrame()],
                           GetSpriteWidth()/2, GetSpriteHeight()/2,
                           GetInterpolatedXPosition(), GetInterpolatedYPosition(), GetInterpolatedSpriteRotation(), 0);

    if(GetOnDamageGrace())
        al_draw_rotated_bitmap(Image::coreOverloadSub[GetCoreOverloadFrame()], 16, 16, GetInterpolatedXPosition(), GetInterpolatedYPosition(), GetInterpolatedSpriteRotation(), 0);

    DebugDrawPosition(); // only works if #ifdef in Actor.h
    DebugDrawHitbox();

}

void PC::SubshipDrawing()
{
    for(std::vector<Subship*>::iterator it = subships.begin(); it != subships.end(); ++it)
    {
        (*it)->Drawing();
    }
}

void PC::OvershieldDrawing()
{
    if(isPowerupActive[PowerupDropIndex::OVERSHIELD])
        al_draw_rotated_bitmap(Image::overshieldSub[overshieldFrame],
                               128, 128,
                               GetInterpolatedXPosition(), GetInterpolatedYPosition(),
                               overshieldSpriteRotation, 0);
}

void PC::PowerupTimeoutDrawing()
{
    if(isPowerupActive[trackedPowerup])
    {
        float barWidth = POWERUP_TIMEOUT_BAR_WIDTH * ((float)powerupNumCharges[trackedPowerup] / PowerupDropIndex::numCharges.at(trackedPowerup) );

        al_draw_filled_rectangle(0, Display::HEIGHT-32, 0 + barWidth, Display::HEIGHT, COLKEY_POWERUP_TIMEOUT_BAR);

        Hax::string_al_draw_text(Font::monogram32, COLKEY_POWERUP_TIMEOUT_BAR_NAME,
                                 0+16, Display::HEIGHT - Font::TEXT_HEIGHT_32,
                                 ALLEGRO_ALIGN_LEFT, PowerupDropIndex::powerupNames.at(trackedPowerup));
    }
}
