#include "particle.h"

std::vector<Particle*> Particle::particles;
std::vector<Particle*> Particle::afterimages;

Particle::Particle()
{

}

Particle::~Particle()
{
    //std::cout << "destructor test " << std::endl;
}

void Particle::Initialize(int form, float speed, float angle, int lifespan)
{
    Actor::Initialize();

    SetForm(form);
    SetIsFlippedHorizontal(false);

    SetMoveSpeed(speed);
    SetMoveAngle(angle);
    SetAllSpriteRotations(angle);
    SetLifespan(lifespan);

    SetNumFrames(ParticleIndex::NUM_FRAMES);
    if(form >= ParticleIndex::FORM_AFTERIMAGE_MARKER_BEGIN)
    {
        if(GetNumFrames() > 0) // Just to prevent division by 0
            SetMaxFrameDelay( lifespan / GetNumFrames() ); // So as to cycle through its frames only once.

        if(GetForm() == ParticleIndex::PARTICLE_SCHEHERAZADE_AFTERIMAGE)
            SetSpriteDimensions(4*Tile::WIDTH, 4*Tile::HEIGHT);
    }
    else
        SetMaxFrameDelay(ParticleIndex::DEFAULT_FRAME_DELAY);

}

void Particle::Logic()
{
    Actor::Logic();

    if(GetIsAlive() && GetIsInBounds())
    {
        lifespanElasped++;
        if(lifespanElasped >= lifespan)
            SetIsAlive(false);

        SetXPosition(GetXPosition() + GetMoveSpeed()*std::cos(GetMoveAngle()));
        SetYPosition(GetYPosition() + GetMoveSpeed()*std::sin(GetMoveAngle()));

        //if(onAfterimageBoost)
            //SetYPosition(GetYPosition() + AFTERIMAGE_BOOST_SPEED);

        SetSpriteRotation(GetMoveAngle());
    }
    else
    {
        if(!GetIsAlive())
        {
            SetIsActive(false);
        }

        if(!GetIsInBounds())
        {
            SetIsActive(false);
        }
    }
}

void Particle::Drawing()
{
    UpdateInterpolation();

    int flags = 0;
    if(isFlippedHorizontal)
        flags = ALLEGRO_FLIP_VERTICAL; // Yeah, not horizontal. It's weird, but the image is rotated 90 degrees CW in the resource png, and flips take priority before rotation.

    al_draw_rotated_bitmap(Image::particleSub[GetForm()*ParticleIndex::NUM_FRAMES + GetCurrentFrame()],
                           GetSpriteWidth()/2, GetSpriteHeight()/2,
                           GetInterpolatedXPosition(), GetInterpolatedYPosition(),
                           GetInterpolatedSpriteRotation(),
                           flags);

    //if(GetForm() == ParticleIndex::PARTICLE_SCHEHERAZADE_AFTERIMAGE)
       // std::cout << "d";

    DebugDrawPosition();
}
