#include "palette.h"

ALLEGRO_COLOR Palette::Eulbink[EULBINK_NUM_COLOURS];
ALLEGRO_COLOR Palette::Eulbink50Alpha[EULBINK_NUM_COLOURS];

ALLEGRO_COLOR Palette::currentClearColour;
ALLEGRO_COLOR Palette::transparentColour;

void Palette::InitializeEulbink()
{
    Eulbink[EULBINK_WHITE]       = al_map_rgb( 255, 255, 255); // Lightest
    Eulbink[EULBINK_TURQUOISE]   = al_map_rgb(  12, 230, 242);
    Eulbink[EULBINK_LIGHT_BLUE]  = al_map_rgb(   0, 152, 219);
    Eulbink[EULBINK_MID_BLUE]    = al_map_rgb(  30,  87, 156);
    Eulbink[EULBINK_DARK_BLUE]   = al_map_rgb(  32,  53,  98);
    Eulbink[EULBINK_PURPLE]      = al_map_rgb(  37,  36,  70);
    Eulbink[EULBINK_DARK_PURPLE] = al_map_rgb(  32,  21,  51); // Darkest

    Eulbink50Alpha[EULBINK_WHITE]       = al_premul_rgba( 255, 255, 255, 128); // Lightest
    Eulbink50Alpha[EULBINK_TURQUOISE]   = al_premul_rgba(  12, 230, 242, 128);
    Eulbink50Alpha[EULBINK_LIGHT_BLUE]  = al_premul_rgba(   0, 152, 219, 128);
    Eulbink50Alpha[EULBINK_MID_BLUE]    = al_premul_rgba(  30,  87, 156, 128);
    Eulbink50Alpha[EULBINK_DARK_BLUE]   = al_premul_rgba(  32,  53,  98, 128);
    Eulbink50Alpha[EULBINK_PURPLE]      = al_premul_rgba(  37,  36,  70, 128);
    Eulbink50Alpha[EULBINK_DARK_PURPLE] = al_premul_rgba(  32,  21,  51, 128); // Darkest

    currentClearColour = COLKEY_BACKGROUND;
    transparentColour = al_map_rgba(0, 0, 0, 0);
}
