#include "overworld.h"

void Overworld::Initialize()
{
    PC::pc = new PC();
    PC::pc->PC::Initialize(PC::HULL_PC_ORTHOS_A);

    Lives::Initialize();
    Arena::Initialize();
    Frame::Initialize();
    Grid::Initialize();
    Score::Initialize();
    Stage::Initialize(1);
}

void Overworld::Uninitialize()
{
    for(std::vector<Bullet*>::iterator it = Bullet::bullets.begin(); it != Bullet::bullets.end();)
    {
        delete *it;
        *it = nullptr;
        it = Bullet::bullets.erase(it);
    }
    for (std::vector<Particle*>::iterator it = Particle::particles.begin(); it != Particle::particles.end();)
    {
        delete *it;
        *it = nullptr;
        it = Particle::particles.erase(it);
    }
    for(std::vector<Particle*>::iterator it = Particle::afterimages.begin(); it != Particle::afterimages.end();)
    {
        delete *it;
        *it = nullptr;
        it = Particle::afterimages.erase(it);
    }

    for(std::vector<NPC*>::iterator it = NPC::npcs.begin(); it != NPC::npcs.end();)
    {
        delete *it;
        *it = nullptr;
        it = NPC::npcs.erase(it);
    }

    for(std::vector<PowerupDrop*>::iterator it = PowerupDrop::powerupDrops.begin(); it != PowerupDrop::powerupDrops.end();)
    {
        delete *it;
        *it = nullptr;
        it = PowerupDrop::powerupDrops.erase(it);
    }

    for (std::vector<FlyingText*>::iterator it = FlyingText::flyingTexts.begin(); it != FlyingText::flyingTexts.end();)
    {
        delete* it;
        *it = nullptr;
        it = FlyingText::flyingTexts.erase(it);
    }

    delete PC::pc;
    PC::pc = nullptr;

    Stage::Uninitialize();
    Arena::Uninitialize();

}

void Overworld::Logic()
{
    Stage::Logic();
    Grid::Logic();
    Frame::Logic();

    PC::pc->Logic();

    for(std::vector<Bullet*>::iterator it = Bullet::bullets.begin(); it != Bullet::bullets.end();)
    {
        if((*it)->GetIsActive())
        {
            (*it)->Logic();
            ++it;
        }
        else
        {
            delete *it;
            *it = nullptr;
            it = Bullet::bullets.erase(it);
        }
    }

    for(std::vector<NPC*>::iterator it = NPC::npcs.begin(); it != NPC::npcs.end();)
    {
        if((*it)->GetIsActive())
        {
            (*it)->Logic();
            ++it;
        }
        else
        {
            delete *it;
            *it = nullptr;
            it = NPC::npcs.erase(it);
        }
    }

    for(std::vector<Particle*>::iterator it = Particle::particles.begin(); it != Particle::particles.end();)
    {
        if((*it)->GetIsActive())
        {
            (*it)->Logic();
            ++it;
        }
        else
        {
            delete *it;
            *it = nullptr;
            it = Particle::particles.erase(it);
        }
    }

    for(std::vector<Particle*>::iterator it = Particle::afterimages.begin(); it != Particle::afterimages.end();)
    {
        if((*it)->GetIsActive())
        {
            (*it)->Logic();
            if(Arena::pursuitModeActive)
                (*it)->SetYPosition((*it)->GetYPosition() + Arena::PURSUIT_MODE_AFTERIMAGE_Y_BOOST);

            ++it;
        }
        else
        {
            delete *it;
            *it = nullptr;
            it = Particle::afterimages.erase(it);
        }

    }

    for(std::vector<PowerupDrop*>::iterator it = PowerupDrop::powerupDrops.begin(); it != PowerupDrop::powerupDrops.end();)
    {
        if((*it)->GetIsActive())
        {
            (*it)->Logic();
            ++it;
        }
        else
        {
            delete *it;
            *it = nullptr;
            it = PowerupDrop::powerupDrops.erase(it);
        }
    }

    for (std::vector<FlyingText*>::iterator it = FlyingText::flyingTexts.begin(); it != FlyingText::flyingTexts.end();)
    {
        if ((*it)->GetIsActive())
        {
            (*it)->Logic();
            ++it;
        }
        else
        {
            delete* it;
            *it = nullptr;
            it = FlyingText::flyingTexts.erase(it);
        }
    }
    Score::Logic();

    Camera::Logic();
}

void Overworld::Input()
{
    if(Keyboard::keyHoldTicks[Keyboard::KEY_UP] > 0)
        PC::pc->SetMoveInputReceived(Direction::UP, true);

    if(Keyboard::keyHoldTicks[Keyboard::KEY_DOWN] > 0)
        PC::pc->SetMoveInputReceived(Direction::DOWN, true);

    if(Keyboard::keyHoldTicks[Keyboard::KEY_LEFT] > 0)
        PC::pc->SetMoveInputReceived(Direction::LEFT, true);

    if(Keyboard::keyHoldTicks[Keyboard::KEY_RIGHT] > 0)
        PC::pc->SetMoveInputReceived(Direction::RIGHT, true);

    if (Keyboard::keyHoldTicks[Keyboard::KEY_Z] > 0)
        PC::pc->SetFireInputReceived(0, true);

    if(Keyboard::keyHoldTicks[Keyboard::KEY_X] > 0)
        PC::pc->SetFireInputReceived(1, true);

    if(Keyboard::keyHoldTicks[Keyboard::KEY_C] > 0)
        PC::pc->SetFireInputReceived(2, true);

    if(Keyboard::keyHoldTicks[Keyboard::KEY_ESC] == 1)
    {
        Scene::ChangeScene(Scene::SCENE_TITLE);
        //if(Stage::inFinalIntermission)
        //{
            Reset();
        //}
    }
}

void Overworld::Drawing()
{
    al_set_target_bitmap(Camera::cameraBuffer);
    al_clear_to_color(Palette::currentClearColour);

    Grid::Drawing();

    PC::pc->UpdateInterpolation();
    PC::pc->OvershieldDrawing();

    for(std::vector<Particle*>::iterator it = Particle::afterimages.begin(); it != Particle::afterimages.end(); ++it)
        (*it)->Drawing();

    for(std::vector<NPC*>::iterator it = NPC::npcs.begin(); it != NPC::npcs.end(); ++it)
        (*it)->Drawing();

    PC::pc->MainDrawing();

    for(std::vector<PowerupDrop*>::iterator it = PowerupDrop::powerupDrops.begin(); it != PowerupDrop::powerupDrops.end(); ++it)
        (*it)->Drawing();

    for(std::vector<Particle*>::iterator it = Particle::particles.begin(); it != Particle::particles.end(); ++it)
        (*it)->Drawing();

    PC::pc->SubshipDrawing();

    for(std::vector<Bullet*>::iterator it = Bullet::bullets.begin(); it != Bullet::bullets.end(); ++it)
        (*it)->Drawing();

    for(std::vector<FlyingText*>::iterator it = FlyingText::flyingTexts.begin(); it != FlyingText::flyingTexts.end(); ++it)
        (*it)->Drawing();

    al_set_target_bitmap(al_get_backbuffer(Display::display));
    al_clear_to_color(Palette::currentClearColour);
    al_draw_bitmap(Camera::cameraBuffer, Arena::X_POSITION, Arena::Y_POSITION, 0);

    Stage::Drawing();

    Frame::Drawing();

    PC::pc->PowerupTimeoutDrawing();
}

void Overworld::Reset()
{
    Uninitialize();
    Initialize();

    Audio::SetActiveBgm(Audio::titleBgm , 0);
}
