#include "npc.h"

std::vector<NPC*> NPC::npcs;

NPC::NPC()
{
    shadowedShip = nullptr;
}

NPC::~NPC()
{
    //std::cout << "beep" << std::endl;
    //std::cout << GetXPosition() << ", " << GetYPosition() << std::endl;
    //std::cout << GetPreviousXPosition() << ", " << GetPreviousYPosition() << std::endl;
    //std::cout << GetInterpolatedXPosition() << ", " << GetInterpolatedYPosition() << std::endl;
    //std::cout << std::endl;

}

void NPC::Initialize(int whichHullType, float x_pos, float y_pos, float x_dest, float y_dest)
{
    Ship::Initialize();
    Ship::SetHullType(whichHullType);

    SetAllXYPositions(x_pos, y_pos);
    SetXYDestination(x_dest, y_dest);

    SetScoreValue(Score::npcDestructionValue.at(ShipIndex::npcScoreTier.at(whichHullType)));

    if(ShipIndex::npcMaxHP.count(whichHullType) > 0)
        SetMaxHP(ShipIndex::npcMaxHP.at(whichHullType));
    else
        SetMaxHP(ShipIndex::DEFAULT_NPC_MAX_HP);

    if(ShipIndex::npcMoveSpeed.count(whichHullType) > 0)
        SetMoveSpeed(ShipIndex::npcMoveSpeed.at(whichHullType));
    else
        SetMoveSpeed(ShipIndex::DEFAULT_NPC_MOVE_SPEED);

    SetSpriteDimensions(ShipIndex::npcSpriteDimensions.at(whichHullType).first, ShipIndex::npcSpriteDimensions.at(whichHullType).second);
    SetHitboxXYOffset(ShipIndex::npcHitboxXYOffset.at(whichHullType).first, ShipIndex::npcHitboxXYOffset.at(whichHullType).second);
    SetHitboxDimensions(ShipIndex::npcHitboxDimensions.at(whichHullType).first, ShipIndex::npcHitboxDimensions.at(whichHullType).second);

    isSelfdestructing = false;
    hasBossProtocol = false;

    switch(Ship::GetHullType())
    {
    case ShipIndex::HULL_NPC_RAY:
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_RAY_MAIN));
        break;

    case ShipIndex::HULL_NPC_OCELLUS:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_OCELLUS_MAIN));
        break;

    case ShipIndex::HULL_NPC_ANGELFISH:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_ANGELFISH_MAIN));
        break;

    case ShipIndex::HULL_NPC_ANTLION:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_ANTLION_MAIN));
        break;

    case ShipIndex::HULL_NPC_DISCUS:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_DISCUS_MAIN));
        break;

    case ShipIndex::HULL_NPC_CONSTANT:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_CONSTANT_SELFDESTRUCT));
        isSelfdestructing = true;
        break;

    case ShipIndex::HULL_NPC_CROSS:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_CROSS_MAIN));
        break;

    case ShipIndex::HULL_NPC_MISSILE:
        AddEmitter(new Emitter(EmitterIndex::EmitterIndex::EMITTER_PRESET_MISSILE_SELFDESTRUCT));
        isSelfdestructing = true;
        break;

    case ShipIndex::HULL_NPC_PARTISAN:
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_PARTISAN_SUPPRESSION));
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_PARTISAN_PERSISTENT));
        break;

    case ShipIndex::HULL_NPC_SUNFISH:
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_SUNFISH_MAIN));
        break;

    case ShipIndex::HULL_NPC_SPIRIT:
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_SPIRIT_MAIN));
        break;

    case ShipIndex::HULL_NPC_AEGIS:
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_AEGIS_SUPPRESSION));
        AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_AEGIS_LASER));
        break;

    case ShipIndex::HULL_NPC_SCHEHERAZADE:
        EnableAfterimages(ParticleIndex::PARTICLE_SCHEHERAZADE_AFTERIMAGE);
        break;

    default:

        break;
    }

    for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end(); ++it)
    {
        (*it)->SetIsNPCEmitter(true);

        if(isSelfdestructing)
            (*it)->SetIsOnline(false);
    }

    SetMoveAngle(0.25 * 2*ALLEGRO_PI);

    spawnFiringDelay = DEFAULT_SPAWN_FIRING_DELAY;
}

void NPC::Logic()
{
    Ship::Logic();

    if(GetIsAlive() && GetIsInBounds())
    {
        if(GetHasDestination() && !GetIsAtDestination())
        {
            float opposite = GetYDestination() - GetYPosition();
            float adjacent = GetXDestination() - GetXPosition();
            SetMoveAngle( std::atan2(opposite, adjacent) );
            SetXPosition( GetXPosition() + std::cos(GetMoveAngle())*GetMoveSpeed());
            SetYPosition( GetYPosition() + std::sin(GetMoveAngle())*GetMoveSpeed());

            if(std::abs(GetXDestination() - GetXPosition()) <= GetMoveSpeed()
                    && std::abs(GetYDestination() - GetYPosition()) <= GetMoveSpeed())
            {
                SetIsAtDestination(true);
                if(GetIsAutopilot())
                {
                    DisableAutopilot();
                    if(hasBossProtocol)
                    {
                        EnableAutopilot(Hax::RandFloatRange(Arena::LEFT_WALL, Arena::RIGHT_WALL),
                                        Hax::RandFloatRange(Arena::TOP_WALL, Arena::HEIGHT/2),
                                        GetMoveSpeed()/2, 2*ALLEGRO_PI * -0.25);
                    }

                }
            }
        }

        if(!GetIsAutopilot())
        {
            SetSpriteRotation(GetMoveAngle());

        }
        else
            SetSpriteRotation(GetAutopilotFixedSpriteRotation());

        AfterimageUpdate(false);

        if(!GetInDeathSequence())
        {
            if(isSelfdestructing)
            {
                if(Hax::AABBCollision(GetXPosition() + GetHitboxXOffset(),GetYPosition() + GetHitboxYOffset(),GetHitboxWidth(),GetHitboxHeight(),
                                      GetTrackedTarget()->GetXPosition() + GetTrackedTarget()->GetHitboxXOffset(), GetTrackedTarget()->GetYPosition() + GetTrackedTarget()->GetHitboxYOffset(), GetTrackedTarget()->GetHitboxWidth(), GetTrackedTarget()->GetHitboxHeight() ) )
                {
                    GetEmitter(0)->Fire();
                    EmitDeathSparks();
                    SetIsAlive(false); // Instant death, no death sequence.
                }
            }

            if(GetCurrentHP() <= 0)
            {
                if(!hasBossProtocol)
                {
                    InitDeathSequence(ShipIndex::DEATH_SEQUENCE_TICKS_DEFAULT);
                    InitDamageBounce(lastCollidingBulletX, lastCollidingBulletY, ShipIndex::NPC_DAMAGE_BOUNCE_VELOCITY);
                }
                else
                {
                    InitDeathSequence(ShipIndex::DEATH_SEQUENCE_TICKS_DEFAULT*6.0);
                    InitDamageBounce(lastCollidingBulletX, lastCollidingBulletY, ShipIndex::NPC_DAMAGE_BOUNCE_VELOCITY);
                }
            }
        }
        else // inDeathSequence
        {
            if(GetDeathSequenceTicks() % ShipIndex::DEATH_SEQUENCE_TICKS_DEFAULT == 0)
            {
                EmitDeathSparks(); // Extra death sparks for extra long battles.
            }

            if(GetDeathSequenceTicks() > GetDeathSequenceTicksMax())
            {
                EmitDeathSparks();
                SetIsAlive(false);

                Score::npcsDestroyed ++;
                Score::AddNPCDestructionValue(scoreValue);

                FlyingText* scoreText = new FlyingText();
                scoreText->Initialize(std::to_string(scoreValue*Score::multiplierValue), FONTDEF_FLYINGTEXT_SCORE, GetXPosition(), GetYPosition());
                FlyingText::flyingTexts.push_back(scoreText);

                if(Score::npcDestructionChain%4 == 0 && Score::powerupDropAvailable && scoreValue >= MIN_SCORE_VALUE_TO_DROP_POWERUP)
                {
                    DropPowerup();
                    Score::ResetPowerupDrop();
                    //std::cout << "powerup drop..." << std::endl;
                }
            }
        }

        for(std::vector<Bullet*>::iterator it = Bullet::bullets.begin(); it != Bullet::bullets.end(); ++it)
        {
            if(!(*it)->GetIsNPCBullet())
            {
                if(Hax::AABBCollision(GetXPosition() + GetHitboxXOffset(), GetYPosition() + GetHitboxYOffset(), GetHitboxWidth(), GetHitboxHeight(),
                                      (*it)->GetXPosition() + (*it)->GetHitboxXOffset(), (*it)->GetYPosition() + (*it)->GetHitboxYOffset(), (*it)->GetHitboxWidth(), (*it)->GetHitboxHeight()))
                {

                    lastCollidingBulletX = (*it)->GetXPosition();
                    lastCollidingBulletY = (*it)->GetYPosition();

                    if((*it)->GetIsPersistent())
                    {
                        if( std::count(GetPersistentBulletHitsVector().begin(), GetPersistentBulletHitsVector().end(), *it) == 0)
                        {
                            SetCurrentHP(GetCurrentHP() - (*it)->GetDamage());
                            if(hasBossProtocol)
                                bossProtocolDamageToQuarterHP -= (*it)->GetDamage();

                            (*it)->EmitHitSparks(ParticleIndex::PARTICLE_HIT_BLACK, 6);
                            AddPersistentBulletHits(*it);

                        }
                    }
                    else
                    {
                        if(!GetInDeathSequence()) // So that "dead" ships don't keep sponging up bullets
                        {
                            SetCurrentHP(GetCurrentHP() - (*it)->GetDamage());
                            if(hasBossProtocol)
                                bossProtocolDamageToQuarterHP -= (*it)->GetDamage();

                            (*it)->EmitHitSparks(ParticleIndex::PARTICLE_HIT_BLUE, 6);
                            (*it)->SetIsActive(false);
                        }
                    }

                    if(!GetOnDamageGrace())
                    {
                        InitDamageGrace(ShipIndex::COSMETIC_DAMAGE_GRACE_TICKS_MAX);
                    }
                }
            }
        } // bullet vector iteration


        if(hasBossProtocol)
        {
            bossProtocolEmitterRandomizationTick ++;
            if(bossProtocolEmitterRandomizationTick > BOSS_PROTOCOL_EMITTER_RANDOMIZATION_TICKS_MAX)
            {
                bossProtocolEmitterRandomizationTick = 0;
                for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end();)
                {
                    delete *it;
                    *it = nullptr;
                    it = GetEmitterVector().erase(it);
                }
                AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_RAY_MAIN + std::rand()% (EmitterIndex::EMITTER_PRESET_AEGIS_LASER - EmitterIndex::EMITTER_PRESET_RAY_MAIN + 1  )));
                AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_RAY_MAIN + std::rand()% (EmitterIndex::EMITTER_PRESET_AEGIS_LASER - EmitterIndex::EMITTER_PRESET_RAY_MAIN + 1  )));
                AddEmitter(new Emitter(EmitterIndex::EMITTER_PRESET_RAY_MAIN + std::rand()% (EmitterIndex::EMITTER_PRESET_AEGIS_LASER - EmitterIndex::EMITTER_PRESET_RAY_MAIN + 1  )));

                for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end(); ++it)
                    (*it)->SetIsNPCEmitter(true);

            }

            if(bossProtocolDamageToQuarterHP <= 0)
            {
                DropPowerup();
                bossProtocolDamageToQuarterHP = ShipIndex::npcMaxHP.at(ShipIndex::HULL_NPC_SCHEHERAZADE) / 4;
            }
        }

    }
    else // ! isAlive or !inBounds
    {
        if(!GetIsAlive())
            SetIsActive(false);

        if(!GetIsInBounds())
        {
            //std::cout << "oob debug " << std::endl;
            SetIsActive(false);
        }
    }
}

void NPC::Drawing()
{
    UpdateInterpolation();

    al_draw_rotated_bitmap(Image::npcShipSub[GetHullType()],
                           GetSpriteWidth()/2, GetSpriteHeight()/2,
                           GetInterpolatedXPosition(), GetInterpolatedYPosition(),
                           GetInterpolatedSpriteRotation() /*+ GetDamageBounceRotationOffset()*/,
                           0);

    if(GetInDeathSequence() || GetOnDamageGrace())
        al_draw_rotated_bitmap(Image::coreOverloadSub[GetCoreOverloadFrame()], 16, 16, GetInterpolatedXPosition(), GetInterpolatedYPosition(), GetInterpolatedSpriteRotation() /*+ GetDamageBounceRotationOffset()*/, 0);

    for(std::vector<Emitter*>::iterator it = GetEmitterVector().begin(); it != GetEmitterVector().end(); ++it)
        (*it)->DrawTelegraph(GetMoveAngle());

    DebugDrawPosition();
    DebugDrawHitbox();
}

void NPC::EmitDeathSparks()
{
    float circleAngle = 0;
    int numSparks = 12;

    Particle*spark;

    for(int i = 0; i < numSparks; i++)
    {
        circleAngle += (2*ALLEGRO_PI)/numSparks;

        spark = new Particle();
        spark->Initialize(ParticleIndex::PARTICLE_EXPLODE, 10, circleAngle, 16);
        spark->SetAllXYPositions(GetXPosition(), GetYPosition());
        Particle::particles.push_back(spark);
    }

    size_t r = std::rand()%Audio::NUM_EXPLOSIONS;
    Audio::AddSfx(Audio::explosion[r]);
}

void NPC::DropPowerup()
{
    PowerupDrop* drop = new PowerupDrop();
    drop->Initialize(GetXPosition(), GetYPosition());

    PowerupDrop::powerupDrops.push_back(drop);
}

void NPC::EnableBossProtocol()
{
    hasBossProtocol = true;
    EnableAutopilot(GetXDestination(), GetYDestination(), GetMoveSpeed(), 2*ALLEGRO_PI* -0.25);
    bossProtocolDamageToQuarterHP = ShipIndex::npcMaxHP.at(ShipIndex::HULL_NPC_SCHEHERAZADE) / 4;
    bossProtocolEmitterRandomizationTick = BOSS_PROTOCOL_EMITTER_RANDOMIZATION_TICKS_MAX;
}
