#include "image.h"

ALLEGRO_BITMAP* Image::titleOptionMarkerPng;
ALLEGRO_BITMAP* Image::settingsVolumeBarPng;
ALLEGRO_BITMAP* Image::settingsVolumeBarEmptyPng;

ALLEGRO_BITMAP* Image::comboCounterEmptyPng;
ALLEGRO_BITMAP* Image::comboCounterPng;
ALLEGRO_BITMAP* Image::comboCounterSub[4];

ALLEGRO_BITMAP* Image::frameEventWarningCombinedPng;
ALLEGRO_BITMAP* Image::frameEventWarningRows[FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS * FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES];

ALLEGRO_BITMAP* Image::pcCorePng;
ALLEGRO_BITMAP* Image::pcCoreSub[ShipIndex::PC_CORE_NUM_FRAMES];

ALLEGRO_BITMAP* Image::subshipPng;
ALLEGRO_BITMAP* Image::subshipSub[ShipIndex::SUBSHIP_HULL_NUM_TYPES * ShipIndex::SUBSHIP_NUM_FRAMES];

ALLEGRO_BITMAP *Image::npcShipPng;
ALLEGRO_BITMAP *Image::npcShipSub[ShipIndex::HULL_NPC_NUM_TYPES];

ALLEGRO_BITMAP *Image::coreOverloadPng;
ALLEGRO_BITMAP *Image::coreOverloadSub[ShipIndex::NUM_CORE_OVERLOAD_FRAMES];

ALLEGRO_BITMAP* Image::bulletMainDarkPng;
ALLEGRO_BITMAP* Image::bulletSlashPng;
ALLEGRO_BITMAP* Image::bulletSub[BulletIndex::NUM_ALL_SHAPES * BulletIndex::NUM_FRAMES];

ALLEGRO_BITMAP* Image::particlePng;
ALLEGRO_BITMAP* Image::scheherazadeAfterimagePng;
ALLEGRO_BITMAP* Image::particleSub[ParticleIndex::NUM_PARTICLE_FORMS * ParticleIndex::NUM_FRAMES];

ALLEGRO_BITMAP* Image::powerupDropPng;
ALLEGRO_BITMAP* Image::powerupDropSub[PowerupDropIndex::NUM_EFFECTS];

ALLEGRO_BITMAP *Image::overshieldPng;
ALLEGRO_BITMAP *Image::overshieldSub[PowerupDropIndex::OVERSHIELD_NUM_FRAMES];

ALLEGRO_BITMAP* Image::emitterTelegraphPng;
ALLEGRO_BITMAP* Image::emitterTelegraphSub[EmitterIndex::NUM_EMITTER_TELEGRAPH_FRAMES * EmitterIndex::NUM_EMITTER_TELEGRAPH_COLOURS];

void Image::Initialize()
{
    al_init_image_addon();
    al_init_primitives_addon();

    LoadResources();
}

void Image::Uninitialize()
{
    UnloadResources();
    al_shutdown_primitives_addon();
    al_shutdown_image_addon();
}

void Image::LoadResources()
{
    titleOptionMarkerPng = al_load_bitmap("titleOptionMarker.png");
    settingsVolumeBarPng = al_load_bitmap("settingsVolumeBar.png");
    settingsVolumeBarEmptyPng = al_load_bitmap("settingsVolumeBarEmpty.png");

    comboCounterEmptyPng = al_load_bitmap("comboCounterEmpty.png");

    comboCounterPng = al_load_bitmap("comboCounter.png");
    for(size_t i = 0; i < 4; i++)
        comboCounterSub[i] = al_create_sub_bitmap(comboCounterPng, 0, 64*i, 64, 64);

    frameEventWarningCombinedPng = al_load_bitmap("frameEventWarningCombined.png");
    for(size_t y = 0; y < FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS; y++)
    {
        for(size_t x = 0; x < FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES; x++)
        {
            frameEventWarningRows[y*FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES + x] = al_create_sub_bitmap(frameEventWarningCombinedPng, x*480, y*24, 480, 24);
        }
    }


    pcCorePng = al_load_bitmap("pcCore.png");
    for(size_t i = 0; i < ShipIndex::PC_CORE_NUM_FRAMES; i++)
        pcCoreSub[i] = al_create_sub_bitmap(pcCorePng, i*Tile::WIDTH, 0, Tile::WIDTH, Tile::HEIGHT);

    subshipPng = al_load_bitmap("subship.png");
    for(size_t y = 0; y < ShipIndex::SUBSHIP_HULL_NUM_TYPES; y++)
    {
        for(size_t x = 0; x < ShipIndex::SUBSHIP_NUM_FRAMES; x++)
        {
            subshipSub[y*ShipIndex::SUBSHIP_NUM_FRAMES + x] = al_create_sub_bitmap(subshipPng, x*Tile::WIDTH, y*Tile::HEIGHT, Tile::WIDTH, Tile::HEIGHT);
            //std::cout << "+";
        }
        //std::cout << std::endl;
    }
    //std::cout << "subshipSub_size" << ShipIndex::SUBSHIP_HULL_NUM_TYPES * ShipIndex::SUBSHIP_NUM_FRAMES << std::endl;

    npcShipPng = al_load_bitmap("npcShip.png");
    for(size_t i = ShipIndex::HULL_NPC_SMALL_SHIP_MARKER_BEGIN; i <= ShipIndex::HULL_NPC_SMALL_SHIP_MARKER_END; i++)
        npcShipSub[i] = al_create_sub_bitmap(npcShipPng, 0*Tile::WIDTH,   i*Tile::HEIGHT,                                               1*Tile::WIDTH, 1*Tile::HEIGHT);
    for(size_t i = ShipIndex::HULL_NPC_DRONE_MARKER_BEGIN; i <= ShipIndex::HULL_NPC_DRONE_MARKER_END; i++)
        npcShipSub[i] = al_create_sub_bitmap(npcShipPng, 1*Tile::WIDTH,   (i-ShipIndex::HULL_NPC_DRONE_MARKER_BEGIN)*Tile::HEIGHT,      1*Tile::WIDTH, 1*Tile::HEIGHT);
    for(size_t i = ShipIndex::HULL_NPC_LARGE_SHIP_MARKER_BEGIN; i <= ShipIndex::HULL_NPC_LARGE_SHIP_MARKER_END; i++)
        npcShipSub[i] = al_create_sub_bitmap(npcShipPng, 2*Tile::WIDTH, 2*(i-ShipIndex::HULL_NPC_LARGE_SHIP_MARKER_BEGIN)*Tile::HEIGHT, 2*Tile::WIDTH, 2*Tile::HEIGHT);
    for(size_t i = ShipIndex::HULL_NPC_MECHA_MARKER_BEGIN; i <= ShipIndex::HULL_NPC_MECHA_MARKER_END; i++)
        npcShipSub[i] = al_create_sub_bitmap(npcShipPng, 4*Tile::WIDTH,   (i-ShipIndex::HULL_NPC_MECHA_MARKER_BEGIN)*Tile::HEIGHT,      1*Tile::WIDTH, 1*Tile::HEIGHT);
    for(size_t i = ShipIndex::HULL_NPC_BOSS_MARKER_BEGIN; i <= ShipIndex::HULL_NPC_BOSS_MARKER_END; i++)
        npcShipSub[i] = al_create_sub_bitmap(npcShipPng, 5*Tile::WIDTH, 4*(i-ShipIndex::HULL_NPC_BOSS_MARKER_BEGIN)*Tile::HEIGHT,       4*Tile::WIDTH, 4*Tile::HEIGHT);

    coreOverloadPng = al_load_bitmap("coreOverload.png");
    for(size_t i = 0; i < ShipIndex::NUM_CORE_OVERLOAD_FRAMES; i++)
        coreOverloadSub[i] = al_create_sub_bitmap(coreOverloadPng, i*32, 0, 32, 32);


    bulletMainDarkPng = al_load_bitmap("bulletMainDark.png");
    for(size_t y = BulletIndex::SHAPE_MAIN_MARKER_BEGIN; y < BulletIndex::NUM_MAIN_SHAPES; y++)
    {
        for(size_t x = 0; x < BulletIndex::NUM_FRAMES; x++)
        {
            bulletSub[y*BulletIndex::NUM_FRAMES + x] = al_create_sub_bitmap(bulletMainDarkPng,  x*Tile::WIDTH, y*Tile::HEIGHT, Tile::WIDTH, Tile::HEIGHT);
        }
    }
    for(size_t y = BulletIndex::SHAPE_DARK_MARKER_BEGIN; y < BulletIndex::SHAPE_DARK_MARKER_BEGIN+BulletIndex::NUM_DARK_SHAPES; y++)
    {
        for(size_t x = 0; x < BulletIndex::NUM_FRAMES; x++)
        {
            bulletSub[y*BulletIndex::NUM_FRAMES + x] = al_create_sub_bitmap(bulletMainDarkPng,  x*Tile::WIDTH, y*Tile::HEIGHT, Tile::WIDTH, Tile::HEIGHT);
        }
    }
    bulletSlashPng = al_load_bitmap("bulletSlash.png");
    for(size_t y = BulletIndex::SHAPE_SLASH_MARKER_BEGIN; y < BulletIndex::SHAPE_SLASH_MARKER_BEGIN+BulletIndex::NUM_SLASH_SHAPES; y++)
    {
        for(size_t x = 0; x < BulletIndex::NUM_FRAMES; x++)
        {
            bulletSub[y*BulletIndex::NUM_FRAMES + x] = al_create_sub_bitmap(bulletSlashPng,  2*x*Tile::WIDTH, 0*Tile::HEIGHT, 2*Tile::WIDTH, 3*Tile::HEIGHT);
            // Changed to use only the "vertical crescent slash" sprite as the horizontal crescent is ugly.
        }
    }


    particlePng = al_load_bitmap("particle.png");
    for(size_t y = ParticleIndex::PARTICLE_PNG_MARKER_BEGIN; y <= ParticleIndex::PARTICLE_PNG_MARKER_END; y++)
    {
        for(size_t x = 0; x < ParticleIndex::NUM_FRAMES; x++)
        {
            particleSub[y*ParticleIndex::NUM_FRAMES + x] = al_create_sub_bitmap(particlePng, x*Tile::WIDTH, y*Tile::HEIGHT, Tile::WIDTH, Tile::HEIGHT);
        }
    }
    scheherazadeAfterimagePng = al_load_bitmap("scheherazadeAfterimage.png");
    for(size_t y = ParticleIndex::PARTICLE_BOSS_AFTERIMAGE_PNG_MARKER_BEGIN; y <= ParticleIndex::PARTICLE_BOSS_AFTERIMAGE_PNG_MARKER_END; y++)
    {
        for(size_t x = 0; x < ParticleIndex::NUM_FRAMES; x++)
        {
            particleSub[y*ParticleIndex::NUM_FRAMES + x] = al_create_sub_bitmap(scheherazadeAfterimagePng, (4*x)*Tile::WIDTH, 0*Tile::HEIGHT, 4*Tile::WIDTH, 4*Tile::HEIGHT);
        }
    }

    powerupDropPng = al_load_bitmap("powerupDrop.png");
    for(size_t i = 0; i < PowerupDropIndex::NUM_EFFECTS; i++)
        powerupDropSub[i] = al_create_sub_bitmap(powerupDropPng, Tile::WIDTH*i, 0, Tile::WIDTH, Tile::HEIGHT);

    overshieldPng = al_load_bitmap("overshield.png");
    for(size_t i = 0; i < PowerupDropIndex::OVERSHIELD_NUM_FRAMES; i++)
        overshieldSub[i] = al_create_sub_bitmap(overshieldPng, 2*i*Tile::WIDTH, 0, 2*Tile::WIDTH, 2*Tile::HEIGHT);

    emitterTelegraphPng = al_load_bitmap("emitterTelegraph.png");
    for(size_t i = 0; i < EmitterIndex::NUM_EMITTER_TELEGRAPH_FRAMES * EmitterIndex::NUM_EMITTER_TELEGRAPH_COLOURS; i++)
    {
        emitterTelegraphSub[i] = al_create_sub_bitmap(emitterTelegraphPng, i*Tile::WIDTH, 0, Tile::WIDTH, Tile::HEIGHT);
    }

}

void Image::UnloadResources()
{
    al_destroy_bitmap(titleOptionMarkerPng);
    al_destroy_bitmap(settingsVolumeBarPng);
    al_destroy_bitmap(settingsVolumeBarEmptyPng);

    al_destroy_bitmap(comboCounterEmptyPng);
    for(size_t i = 0; i < 4; i++)
        al_destroy_bitmap(comboCounterSub[i]);
    al_destroy_bitmap(comboCounterPng);

    for(size_t i = 0; i < FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS * FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES; i++)
        al_destroy_bitmap(frameEventWarningRows[i]);
    al_destroy_bitmap(frameEventWarningCombinedPng);

    for(size_t i = 0; i < ShipIndex::PC_CORE_NUM_FRAMES; i++)
        al_destroy_bitmap(pcCoreSub[i]);
    al_destroy_bitmap(pcCorePng);

    for(size_t i = 0; i < ShipIndex::SUBSHIP_HULL_NUM_TYPES * ShipIndex::SUBSHIP_NUM_FRAMES; i++)
        al_destroy_bitmap(subshipSub[i]);
    al_destroy_bitmap(subshipPng);

    for(size_t i = 0; i < ShipIndex::HULL_NPC_NUM_TYPES; i++)
        al_destroy_bitmap(npcShipSub[i]);
    al_destroy_bitmap(npcShipPng);

    for(size_t i = 0; i < ShipIndex::NUM_CORE_OVERLOAD_FRAMES; i++)
        al_destroy_bitmap(coreOverloadSub[i]);
    al_destroy_bitmap(coreOverloadPng);

    for(size_t i = 0; i < BulletIndex::NUM_ALL_SHAPES * BulletIndex::NUM_FRAMES; i++)
        al_destroy_bitmap(bulletSub[i]);
    al_destroy_bitmap(bulletMainDarkPng);
    al_destroy_bitmap(bulletSlashPng);

    for(size_t i = 0; i < ParticleIndex::NUM_PARTICLE_FORMS * ParticleIndex::NUM_FRAMES; i++)
        al_destroy_bitmap(particleSub[i]);
    al_destroy_bitmap(particlePng);
    al_destroy_bitmap(scheherazadeAfterimagePng);

    for(size_t i = 0; i < PowerupDropIndex::NUM_EFFECTS; i++)
        al_destroy_bitmap(powerupDropSub[i]);
    al_destroy_bitmap(powerupDropPng);

    for(size_t i = 0; i < PowerupDropIndex::OVERSHIELD_NUM_FRAMES; i++)
        al_destroy_bitmap(overshieldSub[i]);
    al_destroy_bitmap(overshieldPng);

    for(size_t i = 0; i < EmitterIndex::NUM_EMITTER_TELEGRAPH_FRAMES * EmitterIndex::NUM_EMITTER_TELEGRAPH_COLOURS; i++)
        al_destroy_bitmap(emitterTelegraphSub[i]);
    al_destroy_bitmap(emitterTelegraphPng);
}

