#include "grid.h"

float Grid::gridScrollYSpeed;
float Grid::gridScrollPhase;
float Grid::gridScrollX;
float Grid::previousGridScrollX;
float Grid::interpolatedGridScrollX;
float Grid::gridScrollY;
float Grid::previousGridScrollY;
float Grid::interpolatedGridScrollY;

float Grid::darkGridScrollYSpeed;
float Grid::darkGridScrollPhase;
float Grid::darkGridScrollX;
float Grid::previousDarkGridScrollX;
float Grid::interpolatedDarkGridScrollX;
float Grid::darkGridScrollY;
float Grid::previousDarkGridScrollY;
float Grid::interpolatedDarkGridScrollY;

void Grid::Initialize()
{
    gridScrollYSpeed = GRID_SCROLL_Y_SPEED_DEFAULT;
    gridScrollPhase = 0.0;
    gridScrollX = 0;
    previousGridScrollX = 0;
    interpolatedGridScrollX = 0;

    gridScrollY = 0;
    previousGridScrollY = 0;
    interpolatedGridScrollY = 0;

    darkGridScrollYSpeed = DARK_GRID_SCROLL_Y_SPEED_DEFAULT;
    darkGridScrollPhase = 0.0;
    darkGridScrollX = 0.0;
    previousDarkGridScrollX = 0.0;
    interpolatedDarkGridScrollX = 0.0;

    darkGridScrollY = 0.0;
    previousDarkGridScrollY = 0.0;
    interpolatedDarkGridScrollY = 0.0;
}

void Grid::Logic()
{
// light
    gridScrollPhase += 0.004;
    if(gridScrollPhase > 2*ALLEGRO_PI)
    {
        gridScrollPhase -= 2*ALLEGRO_PI;
        gridScrollX = Arena::WIDTH*std::cos(gridScrollPhase);
        previousGridScrollX = gridScrollX;
    }
    else
        gridScrollX = Arena::WIDTH*std::cos(gridScrollPhase);

    gridScrollY += gridScrollYSpeed;
    if(gridScrollY >= GRID_LINE_SEPARATION)
    {
        gridScrollY -= GRID_LINE_SEPARATION;
        previousGridScrollY = gridScrollY;
    }

//dark
    darkGridScrollPhase += 0.002;
    if(darkGridScrollPhase > 2*ALLEGRO_PI)
    {
        darkGridScrollPhase -= 2*ALLEGRO_PI;
        darkGridScrollX = 0.5*Arena::WIDTH*std::cos(darkGridScrollPhase);
        previousDarkGridScrollX = darkGridScrollX;
    }
    else
        darkGridScrollX = 0.5*Arena::WIDTH*std::cos(darkGridScrollPhase);

    darkGridScrollY += darkGridScrollYSpeed;
    if(darkGridScrollY >= DARK_GRID_LINE_SEPARATION)
    {
        darkGridScrollY -= DARK_GRID_LINE_SEPARATION;
        previousDarkGridScrollY = darkGridScrollY;
    }
}

void Grid::Drawing()
{
// Dark grid
    interpolatedDarkGridScrollX = previousDarkGridScrollX*(1.0 - Timer::interpolationFactor) + darkGridScrollX*Timer::interpolationFactor;
    previousDarkGridScrollX = darkGridScrollX;
    interpolatedDarkGridScrollY = previousDarkGridScrollY*(1.0 - Timer::interpolationFactor) + darkGridScrollY*Timer::interpolationFactor;
    previousDarkGridScrollY = darkGridScrollY;

    for(int col = 0-DARK_GRID_NUM_COLUMNS/2; col < DARK_GRID_NUM_COLUMNS; col++) //Columns
    {
        al_draw_line(col*DARK_GRID_LINE_SEPARATION + interpolatedDarkGridScrollX,
                     0, // Start Y
                     col*DARK_GRID_LINE_SEPARATION + interpolatedDarkGridScrollX,
                     Arena::HEIGHT, // End Y
                     COLKEY_DARK_GRID_UNDERLAY,1);
    }

    for(int row = 0- DARK_GRID_NUM_ROWS/2; row < DARK_GRID_NUM_ROWS; row++) //Rows
    {
        al_draw_line(0, // Start X
                     row*DARK_GRID_LINE_SEPARATION + interpolatedDarkGridScrollY, // -1 * 128 + ?
                     Arena::WIDTH, // End X
                     row*DARK_GRID_LINE_SEPARATION + interpolatedDarkGridScrollY, // -1 * 128 + ?
                     COLKEY_DARK_GRID_UNDERLAY,1);
    }

// Light grid
    interpolatedGridScrollX = previousGridScrollX*(1.0 - Timer::interpolationFactor) + gridScrollX*Timer::interpolationFactor;
    previousGridScrollX = gridScrollX;
    interpolatedGridScrollY = previousGridScrollY*(1.0 - Timer::interpolationFactor) + gridScrollY*Timer::interpolationFactor;
    previousGridScrollY = gridScrollY;

    for(int col = 0 - GRID_NUM_COLUMNS/2; col < GRID_NUM_COLUMNS; col++) //Columns
    {
        al_draw_line(col*GRID_LINE_SEPARATION - interpolatedGridScrollX,
                     0, // Start Y
                     col*GRID_LINE_SEPARATION - interpolatedGridScrollX,
                     Arena::HEIGHT, // End Y
                     COLKEY_GRID_UNDERLAY,2);
    }

    for(int row = 0 - GRID_NUM_ROWS/2; row < GRID_NUM_ROWS; row++) //Rows
    {
        al_draw_line(0, // Start X
                     row*GRID_LINE_SEPARATION + interpolatedGridScrollY, // -1 * 128 + ?
                     Arena::WIDTH, // End X
                     row*GRID_LINE_SEPARATION + interpolatedGridScrollY, // -1 * 128 + ?
                     COLKEY_GRID_UNDERLAY,2);
    }
}
