#include "frame.h"

float Frame::comboCounterNumFills;
float Frame::comboCounterRotation;
int Frame::comboMultiplier;

bool Frame::isComboCounterFlashing;
bool Frame::isComboCounterFlashVisible;
int Frame:: comboCounterCurrentFlash;
int Frame::comboCounterFlashCurrentTick;

int Frame::score;
std::string Frame::scoreString;
std::string Frame::comboMultiplierString;

float Frame::comboTimeoutBarWidth;

bool Frame::isTutorialActive;
bool Frame::isCannonTutorialPassed;
bool Frame::isForwardSlashTutorialPassed;
bool Frame::isHorizontalSlashTutorialPassed;
int Frame:: tutorialDisengageDelayTicks;

bool Frame::isAntigenWarningActive;
int Frame::antigenWarningPhase;
int Frame::antigenWarningPhaseTicks;
int Frame::antigenWarningFrame;
float Frame::antigenWarningXPosition[FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS];

void Frame::Initialize()
{
    comboCounterNumFills = 0;
    comboCounterRotation = 0.0;
    comboMultiplier = 1;

    isComboCounterFlashing = false;
    isComboCounterFlashVisible = false;
    comboCounterCurrentFlash = 0;
    comboCounterFlashCurrentTick = 0;

    score = 0;
    UpdateScoreString(score);
    UpdateComboMultiplierString(comboMultiplier);

    comboTimeoutBarWidth = 0;

    isTutorialActive = false;
    isAntigenWarningActive = false;
}

void Frame::Logic()
{
    if (score != Score::score)
    {
        score = Score::score;
        UpdateScoreString(score);
    }

    if(comboMultiplier != Score::multiplierValue)
    {
        comboMultiplier = Score::multiplierValue;
        UpdateComboMultiplierString(comboMultiplier);
    }
    if(Score::isMultiplierOverflowSignal)
    {
        Score::isMultiplierOverflowSignal = false;

        isComboCounterFlashing = true;
        comboCounterCurrentFlash = 0;
        comboCounterFlashCurrentTick = 0;
    }

    if(isComboCounterFlashing)
    {
        comboCounterFlashCurrentTick++;
        if(comboCounterFlashCurrentTick > COMBO_COUNTER_FLASH_NUM_TICKS)
        {
            comboCounterCurrentFlash ++;
            comboCounterFlashCurrentTick = 0;
            if(isComboCounterFlashVisible)
                isComboCounterFlashVisible = false; // If true, make false. If true, make false.
            else
                isComboCounterFlashVisible = true;

            if(comboCounterCurrentFlash > COMBO_COUNTER_NUM_FLASHES)
            {
                comboCounterCurrentFlash = 0;
                isComboCounterFlashing = false;
                isComboCounterFlashVisible = false; // This also ensures a reset, in case there is an odd number of flashes.
            }
        }
    }

    comboCounterRotation -= COMBO_COUNTER_ROTATION_RATE;
    if(comboCounterRotation <  0.0 ) //2*ALLEGRO_PI
        comboCounterRotation += 2*ALLEGRO_PI;

    if(comboMultiplier > 1)
    {
        float barProprtion = ((float)(Score::NPC_DESTRUCTION_RESET_TIME-Score::npcDestructionIdle) / (float)Score::NPC_DESTRUCTION_RESET_TIME );
        comboTimeoutBarWidth = COMBO_TIMEOUT_BAR_FULL_WIDTH * barProprtion;
    }

    if(isAntigenWarningActive)
    {
        for(size_t i = 0; i < FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS; i++)
        {
            if(antigenWarningPhase == FrameEventIndex::WARNING_CONVERGE)
            {
                if(antigenWarningXPosition[i] < FrameEventIndex::ANTIGEN_WARNING_X_DESTINATION)
                    antigenWarningXPosition[i] += 24;
                else if(antigenWarningXPosition[i] > FrameEventIndex::ANTIGEN_WARNING_X_DESTINATION)
                    antigenWarningXPosition[i] -= 24;
            }
            else if(antigenWarningPhase == FrameEventIndex::WARNING_SEPERATE)
            {
                int negativeAlternation = 1;
                for(size_t i = 0; i < FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS; i++)
                {
                    negativeAlternation *= (-1);
                    antigenWarningXPosition[i] += 24*negativeAlternation;
                }
            }
        }

        antigenWarningPhaseTicks++;
        if(antigenWarningPhaseTicks % FrameEventIndex::ANTIGEN_WARNING_FRAME_DELAY == 0)
        {
            antigenWarningFrame ++;
            if(antigenWarningFrame >= FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES)
                antigenWarningFrame = 0;
        }

        if(antigenWarningPhaseTicks > FrameEventIndex::ANTIGEN_WARNING_PHASE_TIMEOUT)
        {
            antigenWarningPhase ++;
            antigenWarningPhaseTicks = 0;

            if(antigenWarningPhase > FrameEventIndex::WARNING_SEPERATE)
                isAntigenWarningActive = false;
        }
    }
}

void Frame::Drawing()
{
    Hax::string_al_draw_text(FONTDEF_SCORE_VALUE, COLKEY_SCORE_VALUE, SCORE_READOUT_X, SCORE_READOUT_Y, ALLEGRO_ALIGN_LEFT, scoreString);

    al_draw_rotated_bitmap(Image::comboCounterEmptyPng, COMBO_COUNTER_WIDTH/2, COMBO_COUNTER_HEIGHT/2,
                           COMBO_COUNTER_X + COMBO_COUNTER_WIDTH/2, COMBO_COUNTER_Y + COMBO_COUNTER_HEIGHT/2, comboCounterRotation, 0);


    if(! isComboCounterFlashing)
    {
        size_t numComboCounters = Score::npcDestructionChain%Score::NPC_DESTRUCTIONS_PER_MULTIPLIER_EXPONENT_INCREASE;
        if(numComboCounters > 0)
            al_draw_rotated_bitmap(Image::comboCounterSub[numComboCounters -1], COMBO_COUNTER_WIDTH/2, COMBO_COUNTER_HEIGHT/2,
                                   COMBO_COUNTER_X + COMBO_COUNTER_WIDTH/2, COMBO_COUNTER_Y + COMBO_COUNTER_HEIGHT/2, comboCounterRotation, 0);
    }
    else
    {
        if(isComboCounterFlashVisible)
            al_draw_rotated_bitmap(Image::comboCounterSub[Score::NPC_DESTRUCTIONS_PER_MULTIPLIER_EXPONENT_INCREASE-1], COMBO_COUNTER_WIDTH/2, COMBO_COUNTER_HEIGHT/2,
                                   COMBO_COUNTER_X + COMBO_COUNTER_WIDTH/2, COMBO_COUNTER_Y + COMBO_COUNTER_HEIGHT/2, comboCounterRotation, 0);
    }

    if(comboMultiplier > 1 )
        al_draw_filled_rectangle(COMBO_TIMEOUT_BAR_X, COMBO_TIMEOUT_BAR_Y + COMBO_TIMEOUT_BAR_SQUASH,
                                 COMBO_TIMEOUT_BAR_X + comboTimeoutBarWidth, COMBO_TIMEOUT_BAR_Y + COMBO_TIMEOUT_BAR_HEIGHT - COMBO_TIMEOUT_BAR_SQUASH,
                                 COLKEY_COMBO_TIMEOUT_BAR);

    Hax::string_al_draw_text(FONTDEF_COMBO_MULTIPLIER_VALUE, COLKEY_COMBO_MULTIPLIER_VALUE, COMBO_READOUT_X, COMBO_READOUT_Y, ALLEGRO_ALIGN_LEFT, comboMultiplierString);

    if(isAntigenWarningActive)
    {
        for(size_t i = 0; i < FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS; i++)
            al_draw_bitmap(Image::frameEventWarningRows[i* FrameEventIndex::ANTIGEN_WARNING_NUM_FRAMES + antigenWarningFrame],
                           antigenWarningXPosition[i], FrameEventIndex::ANTIGEN_WARNING_Y + i*FrameEventIndex::ANTIGEN_WARNING_ROW_SEPERATION, 0);
    }

}

void Frame::UpdateScoreString(int score)
{
    // So as to render the score as, say "000012345" instead of just 12345
    std::stringstream ss;
    ss << std::setw(9) << std::setfill('0') << score;
    scoreString = ss.str();
}

void Frame::UpdateComboMultiplierString(int multiplier)
{
    comboMultiplierString = "x" + std::to_string(multiplier);
}

void Frame::InitTutorialFrameEvent()
{
    isCannonTutorialPassed = false;
    isForwardSlashTutorialPassed = false;
    isHorizontalSlashTutorialPassed = false;
    tutorialDisengageDelayTicks = false;
}

void Frame::InitAntigenWarningFrameEvent()
{
    isAntigenWarningActive = true;
    antigenWarningPhase = FrameEventIndex::WARNING_CONVERGE;
    antigenWarningPhaseTicks = 0;
    antigenWarningFrame = 0;

    int negativeAlternation = 1;
    for(size_t i = 0; i < FrameEventIndex::ANTIGEN_WARNING_NUM_ROWS; i++)
    {
        negativeAlternation *= (-1);
        antigenWarningXPosition[i] =  FrameEventIndex::ANTIGEN_WARNING_X_DESTINATION + (FrameEventIndex::ANTIGEN_WARNING_SPAWN_X_DISTANCE*negativeAlternation);
    }

    Audio::AddSfx(Audio::warning0);
}
