#include "font.h"

ALLEGRO_FONT* Font::monogram32;
ALLEGRO_FONT* Font::monogram64;
ALLEGRO_FONT* Font::monogram128;

void Font::Initialize()
{
    al_init_font_addon();
    al_init_ttf_addon();
    LoadResources();
}

void Font::Uninitialize()
{
    UnloadResources();
    al_shutdown_ttf_addon();
    al_shutdown_font_addon();
}

void Font::LoadResources()
{
    monogram32  = al_load_font("monogram.ttf",  32, 0);
    monogram64  = al_load_font("monogram.ttf",  64, 0);
    monogram128 = al_load_font("monogram.ttf", 128, 0);
}

void Font::UnloadResources()
{
    al_destroy_font(monogram32);
    al_destroy_font(monogram64);
    al_destroy_font(monogram128);
}
