#include "flyingtext.h"

std::vector<FlyingText*> FlyingText::flyingTexts;

FlyingText::FlyingText()
{

}

FlyingText::~FlyingText()
{

}

void FlyingText::Initialize(std::string text_content, ALLEGRO_FONT *text_font, int x_position, int y_position)
{
	isActive = true;
	lifespan = BASE_LIFESPAN;

	text = text_content;
	textFont = text_font;

	colourCycleIndex = COLOUR_CYCLE_INDEX_BEGIN;
	colourCycleDelayCount = 0;

	xPosition = x_position;
	yPosition = y_position;
	yDestination = yPosition + Y_TARGET_OFFSET;
	yVelocity = Y_BASE_VELOCITY;
}

void FlyingText::Logic()
{
	lifespan--;
	if (lifespan <= 0)
	{
		isActive = false;
	}

	if(yPosition > yDestination)
        yPosition += yVelocity;

    if(yPosition < Arena::TOP_WALL + Font::TEXT_HEIGHT_64)
        yPosition = Arena::TOP_WALL + Font::TEXT_HEIGHT_64;

    colourCycleDelayCount ++;
    if(colourCycleDelayCount >= COLOUR_CYCLE_DELAY_THRESHOLD)
    {
        colourCycleDelayCount = 0;
        colourCycleIndex ++;
        if(colourCycleIndex > COLOUR_CYCLE_INDEX_END)
            colourCycleIndex = COLOUR_CYCLE_INDEX_BEGIN;
    }

}

void FlyingText::Drawing()
{
	Hax::string_al_draw_text(FONTDEF_FLYINGTEXT_SCORE, Palette::Eulbink[colourCycleIndex], xPosition, yPosition, ALLEGRO_ALIGN_CENTER, text);
}
