#include "bullet.h"

std::vector<Bullet*> Bullet::bullets;

Bullet::Bullet()
{

}

Bullet::~Bullet()
{

}

void Bullet::Initialize(int preset, float angle)
{
    Particle::Initialize(preset, BulletIndex::bulletMovespeed.at(preset), angle, BulletIndex::bulletLifespan.at(preset));

    SetIsNPCBullet(false); // Manually set true after initialization if npc fires bullet
    SetSpriteDimensions(BulletIndex::bulletSpriteDimensions.at( BulletIndex::bulletSprite.at(preset) ).first, BulletIndex::bulletSpriteDimensions.at( BulletIndex::bulletSprite.at(preset) ).second);
    SetHitboxXYOffset(BulletIndex::bulletHitboxXYOffset.at( BulletIndex::bulletSprite.at(preset) ).first, BulletIndex::bulletHitboxXYOffset.at( BulletIndex::bulletSprite.at(preset) ).second);
    SetHitboxDimensions(BulletIndex::bulletHitboxDimensions.at( BulletIndex::bulletSprite.at(preset) ).first, BulletIndex::bulletHitboxDimensions.at( BulletIndex::bulletSprite.at(preset) ).second);

    SetDamage( BulletIndex::bulletDamage.at(preset) );

    SetIsPersistent( BulletIndex::bulletIsPersistent.at(preset) );

    SetNumFrames(BulletIndex::NUM_FRAMES);
    if(!isPersistent)
        SetMaxFrameDelay(Timer::LPS * 0.2);
    else
        SetMaxFrameDelay(Timer::LPS * 0.1);

}

void Bullet::Logic()
{
    Particle::Logic();
    // Bullets are basically particles but subject to collision detection and a different drawing order.

    // Don't do any position update stuff here. That's to be done in Particle::Logic().

    if(isPersistent)
    {
        for(std::vector<Bullet*>::iterator it = bullets.begin(); it != bullets.end(); ++it)
        {
            if(Hax::AABBCollision(GetXPosition() + GetHitboxXOffset(), GetYPosition() + GetHitboxYOffset(), GetHitboxWidth(), GetHitboxHeight(),
                                  (*it)->GetXPosition() + (*it)->GetHitboxXOffset(), (*it)->GetYPosition() + (*it)->GetHitboxYOffset(), (*it)->GetHitboxWidth(), (*it)->GetHitboxHeight()))
            {
                if( ! (*it)->GetIsPersistent())
                {
                    if(( !isNPCBullet  &&  (*it)->isNPCBullet)
                      ||( isNPCBullet  && !(*it)->isNPCBullet))
                    {
                        (*it)->SetIsActive(false);
                        (*it)->EmitHitSparks(ParticleIndex::PARTICLE_HIT_BLUE, 3);
                    }
                }
            }
        }

    }
}

void Bullet::Drawing()
{
    UpdateInterpolation();
    //al_use_shader(Shader::shader);

    al_draw_rotated_bitmap(Image::bulletSub[ BulletIndex::bulletSprite.at(GetForm())*BulletIndex::NUM_FRAMES + GetCurrentFrame() ],
                           GetSpriteWidth()/2, GetSpriteHeight()/2,
                           GetInterpolatedXPosition(), GetInterpolatedYPosition(),
                           GetInterpolatedSpriteRotation(), 0);
    //al_use_shader(NULL);

    DebugDrawPosition();
    DebugDrawHitbox();
}

void Bullet::EmitHitSparks(int particle_form, int num_sparks)
{
    Particle *spark;
    for(int i = 0; i < num_sparks; i++)
    {
        float randAngle = Hax::RandFloatRange(0.0, 2*ALLEGRO_PI);
        float randMoveSpeed = Hax::RandFloatRange(6, 12);
        float randLifespan = Hax::RandFloatRange(8, 24);

        spark = new Particle();
        spark->Initialize(particle_form, randMoveSpeed, randAngle, randLifespan);
        spark->SetAllXYPositions(GetXPosition(), GetYPosition());
        Particle::particles.push_back(spark);
    }
}
